/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.maven.parse;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.commonjava.maven.atlas.ident.ref.ProjectVersionRef;
import org.commonjava.maven.atlas.ident.ref.SimpleProjectVersionRef;
import org.commonjava.maven.galley.model.Transfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PomPeek {
    private static final String G = "g";
    private static final String A = "a";
    private static final String V = "v";
    private static final String PG = "pg";
    private static final String PA = "pa";
    private static final String PV = "pv";
    private static final String PKG = "pkg";
    private static final String PRP = "prp";
    private static final String[] COORD_KEYS = new String[]{"g", "a", "v", "pg", "pa", "pv", "pkg", "prp"};
    private static final String MODULES_ELEM = "modules";
    private static final String PLUGINS_ELEM = "plugins";
    private static final Map<String, String> CAPTURED_PATHS = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put("project:groupId", PomPeek.G);
            this.put("project:artifactId", PomPeek.A);
            this.put("project:version", PomPeek.V);
            this.put("project:packaging", PomPeek.PKG);
            this.put("project:parent:groupId", PomPeek.PG);
            this.put("project:parent:artifactId", PomPeek.PA);
            this.put("project:parent:version", PomPeek.PV);
            this.put("project:parent:relativePath", PomPeek.PRP);
        }
    };
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProjectVersionRef key;
    private final Map<String, String> elementValues = new HashMap<String, String>();
    private final Set<String> modules = new HashSet<String>();
    private final File pom;
    private ProjectVersionRef parentKey;
    private boolean inheritanceRoot = false;
    private final Transfer transfer;
    private final boolean captureModules;
    private final InputStream stream;

    public PomPeek(File pom) {
        this.pom = pom;
        this.transfer = null;
        this.stream = null;
        this.captureModules = true;
        this.init();
    }

    public PomPeek(Transfer transfer) {
        this.pom = null;
        this.transfer = transfer;
        this.stream = null;
        this.captureModules = true;
        this.init();
    }

    public PomPeek(String content) {
        this.pom = null;
        this.transfer = null;
        this.stream = new ByteArrayInputStream(content.getBytes());
        this.captureModules = true;
        this.init();
    }

    public PomPeek(InputStream stream) {
        this.pom = null;
        this.transfer = null;
        this.stream = stream;
        this.captureModules = true;
        this.init();
    }

    public PomPeek(File pom, boolean captureModules) {
        this.pom = pom;
        this.transfer = null;
        this.stream = null;
        this.captureModules = captureModules;
        this.init();
    }

    public PomPeek(Transfer transfer, boolean captureModules) {
        this.pom = null;
        this.transfer = transfer;
        this.stream = null;
        this.captureModules = captureModules;
        this.init();
    }

    public PomPeek(String content, boolean captureModules) {
        this.pom = null;
        this.transfer = null;
        this.stream = new ByteArrayInputStream(content.getBytes());
        this.captureModules = captureModules;
        this.init();
    }

    public PomPeek(InputStream stream, boolean captureModules) {
        this.pom = null;
        this.transfer = null;
        this.stream = stream;
        this.captureModules = captureModules;
        this.init();
    }

    private void init() {
        this.parseCoordElements();
        if (!this.createCoordinateInfo()) {
            this.logger.warn("Could not peek at POM coordinate for: " + this.pom + "\nThis POM will NOT be available as an ancestor to other models during effective-model building.");
        }
    }

    public String getParentRelativePath() {
        return this.elementValues.get(PRP);
    }

    public Set<String> getModules() {
        return this.modules;
    }

    public File getPom() {
        return this.pom;
    }

    public ProjectVersionRef getKey() {
        return this.key;
    }

    public ProjectVersionRef getParentKey() {
        return this.parentKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseCoordElements() {
        in /* !! */  = null;
        xml = null;
        try {
            in /* !! */  = this.pom != null ? new FileInputStream(this.pom) : (this.transfer != null ? this.transfer.openInputStream(false) : this.stream);
            xml = XMLInputFactory.newFactory().createXMLStreamReader(in /* !! */ );
            path = new Stack<String>();
            while (xml.hasNext()) {
                evt = xml.next();
                switch (evt) {
                    case 1: {
                        elem = xml.getLocalName();
                        if (!this.captureValue(elem, path, xml)) break;
                        path.pop();
                        break;
                    }
                    case 2: {
                        path.pop();
                        break;
                    }
                }
                if (!this.foundAll()) continue;
                if (xml == null) ** GOTO lbl44
                ** GOTO lbl39
            }
            ** GOTO lbl46
        }
        catch (IOException | FactoryConfigurationError | XMLStreamException e) {
            block21: {
                try {
                    this.logger.warn("Failed to peek at POM coordinate for: " + this.pom + " Reason: " + e.getMessage() + "\nThis POM will NOT be available as an ancestor to other models during effective-model building.", e);
                    if (xml != null) {
                    }
                    break block21;
                }
                catch (Throwable var6_10) {
                    if (xml != null) {
                        try {
                            xml.close();
                        }
                        catch (XMLStreamException e) {
                            this.logger.warn("Failed to close XMLStreamReader: " + e.getMessage(), (Throwable)e);
                        }
                    }
                    IOUtils.closeQuietly(in /* !! */ );
                    throw var6_10;
                }
lbl39:
                // 1 sources

                try {
                    xml.close();
                }
                catch (XMLStreamException e) {
                    this.logger.warn("Failed to close XMLStreamReader: " + e.getMessage(), (Throwable)e);
                }
lbl44:
                // 3 sources

                IOUtils.closeQuietly((InputStream)in /* !! */ );
                return;
lbl46:
                // 1 sources

                if (xml != null) {
                    try {
                        xml.close();
                    }
                    catch (XMLStreamException e) {
                        this.logger.warn("Failed to close XMLStreamReader: " + e.getMessage(), (Throwable)e);
                    }
                }
                IOUtils.closeQuietly((InputStream)in /* !! */ );
                return;
                try {
                    xml.close();
                }
                catch (XMLStreamException e) {
                    this.logger.warn("Failed to close XMLStreamReader: " + e.getMessage(), (Throwable)e);
                }
            }
            IOUtils.closeQuietly((InputStream)in /* !! */ );
            return;
        }
    }

    private boolean foundAll() {
        for (String key : COORD_KEYS) {
            if (this.elementValues.containsKey(key)) continue;
            return false;
        }
        return !this.captureModules || !"pom".equals(this.elementValues.get(PKG));
    }

    private boolean captureValue(String elem, Stack<String> path, XMLStreamReader xml) throws XMLStreamException {
        boolean isModule = path.contains(MODULES_ELEM) && !path.contains(PLUGINS_ELEM);
        path.push(elem);
        String pathStr = StringUtils.join(path, (String)":");
        String key = CAPTURED_PATHS.get(pathStr);
        if (key != null) {
            this.elementValues.put(key, xml.getElementText().trim());
            return true;
        }
        if (this.captureModules && isModule) {
            this.modules.add(xml.getElementText().trim());
            return true;
        }
        return false;
    }

    private boolean createCoordinateInfo() {
        String v = this.elementValues.get(V);
        String pv = this.elementValues.get(PV);
        if (StringUtils.isEmpty((String)v)) {
            v = pv;
        }
        String g = this.elementValues.get(G);
        String pg = this.elementValues.get(PG);
        if (StringUtils.isEmpty((String)g)) {
            g = pg;
        }
        String a = this.elementValues.get(A);
        String pa = this.elementValues.get(PA);
        boolean valid = false;
        if (this.isValidArtifactId(a) && this.isValidGroupId(g) && this.isValidVersion(v)) {
            this.key = new SimpleProjectVersionRef(g, a, v);
            valid = true;
        }
        if (this.isValidArtifactId(pa) && this.isValidGroupId(pg) && this.isValidVersion(pv)) {
            this.parentKey = new SimpleProjectVersionRef(pg, pa, pv);
        }
        return valid;
    }

    private boolean isValidVersion(String version) {
        return !StringUtils.isEmpty((String)version) && !"version".equals(version) && !"parentVersion".equals(version);
    }

    private boolean isValidGroupId(String groupId) {
        return !StringUtils.isEmpty((String)groupId) && !groupId.contains("${") && !"parentGroupId".equals(groupId) && !"groupId".equals(groupId);
    }

    private boolean isValidArtifactId(String artifactId) {
        return !StringUtils.isEmpty((String)artifactId) && !artifactId.contains("${") && !"parentArtifactId".equals(artifactId) && !"artifactId".equals(artifactId);
    }

    public void setInheritanceRoot(boolean b) {
        this.inheritanceRoot = b;
    }

    public boolean isInheritanceRoot() {
        return this.inheritanceRoot;
    }
}

