/*
 * Decompiled with CFR 0.152.
 */
package org.commonjava.maven.galley.filearc.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.commonjava.maven.galley.TransferException;
import org.commonjava.maven.galley.event.EventMetadata;
import org.commonjava.maven.galley.filearc.internal.AbstractZipOperation;
import org.commonjava.maven.galley.model.Transfer;
import org.commonjava.maven.galley.model.TransferOperation;
import org.commonjava.maven.galley.spi.transport.DownloadJob;

public class ZipDownload
extends AbstractZipOperation
implements DownloadJob {
    private TransferException error;
    private final EventMetadata eventMetadata;

    public ZipDownload(Transfer txfr, EventMetadata eventMetadata) {
        super(txfr);
        this.eventMetadata = eventMetadata;
    }

    public long getTransferSize() {
        return -1L;
    }

    public TransferException getError() {
        return this.error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadJob call() {
        OutputStream out;
        InputStream in;
        ZipFile zf;
        block21: {
            File src;
            block20: {
                src = this.getZipFile();
                if (src.isDirectory()) {
                    return this;
                }
                zf = null;
                in = null;
                out = null;
                zf = this.isJarOperation() ? new JarFile(src) : new ZipFile(src);
                ZipEntry entry = zf.getEntry(this.getFullPath());
                if (entry == null) break block20;
                if (entry.isDirectory()) {
                    this.error = new TransferException("Cannot read stream. Source is a directory: %s!%s", new Object[]{this.getLocation().getUri(), this.getFullPath()});
                    break block21;
                }
                in = zf.getInputStream(entry);
                out = this.getTransfer().openOutputStream(TransferOperation.DOWNLOAD, true, this.eventMetadata);
                IOUtils.copy((InputStream)in, (OutputStream)out);
                ZipDownload zipDownload = this;
                IOUtils.closeQuietly((InputStream)in);
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly((OutputStream)out);
                return zipDownload;
            }
            try {
                this.error = new TransferException("Cannot find entry: %s in: %s", new Object[]{this.getFullPath(), this.getLocation().getUri()});
            }
            catch (IOException e) {
                try {
                    this.error = new TransferException("Failed to copy from: %s to: %s. Reason: %s", (Throwable)e, new Object[]{src, this.getTransfer(), e.getMessage()});
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    if (zf != null) {
                        try {
                            zf.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    IOUtils.closeQuietly(out);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                if (zf != null) {
                    try {
                        zf.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly((OutputStream)out);
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        if (zf != null) {
            try {
                zf.close();
            }
            catch (IOException entry) {
                // empty catch block
            }
        }
        IOUtils.closeQuietly((OutputStream)out);
        if (this.error != null) {
            this.logger.error("Failed to download: {}. Reason: {}", (Object)this, (Object)this.error);
        }
        return null;
    }

    @Override
    public Transfer getTransfer() {
        return super.getTransfer();
    }
}

