/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.invocation;

import java.util.ArrayList;
import java.util.List;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.LiteralValue;

public class ParameterMatch<P extends ParameterDescriptor> {
    private final P parameter;
    private final List<LiteralValue> values;
    private List<String> strings;

    public ParameterMatch(P parameter, List<LiteralValue> values) {
        this.parameter = parameter;
        this.values = values;
        this.strings = null;
    }

    public P getParameter() {
        return this.parameter;
    }

    public List<LiteralValue> getValues() {
        return this.values;
    }

    public List<String> getStrings() {
        if (this.strings == null) {
            ArrayList<String> strings = new ArrayList<String>(this.values.size());
            for (LiteralValue value : this.values) {
                strings.add(((ParameterDescriptor)this.parameter).isUnquote() ? value.getValue() : value.getRawValue());
            }
            this.strings = strings;
        }
        return this.strings;
    }

    public Object computeValue() throws SyntaxException {
        List<String> strings = this.getStrings();
        return ((ParameterDescriptor)this.parameter).parse(strings);
    }
}

