/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.invocation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.crsh.cli.SyntaxException;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.LiteralValue;
import org.crsh.cli.impl.invocation.ArgumentMatch;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.OptionMatch;
import org.crsh.cli.impl.invocation.TokenList;
import org.crsh.cli.impl.parser.Event;
import org.crsh.cli.impl.parser.Mode;
import org.crsh.cli.impl.parser.Parser;
import org.crsh.cli.impl.tokenizer.Token;
import org.crsh.cli.impl.tokenizer.Tokenizer;
import org.crsh.cli.impl.tokenizer.TokenizerImpl;

public class InvocationMatcher<T> {
    private final CommandDescriptor<T> descriptor;
    private Iterable<Token> tokens;

    public InvocationMatcher(CommandDescriptor<T> descriptor) {
        this(descriptor, Collections.emptyList());
    }

    private InvocationMatcher(CommandDescriptor<T> descriptor, Iterable<Token> tokens) {
        this.descriptor = descriptor;
        this.tokens = tokens;
    }

    public InvocationMatcher<T> subordinate(String name) throws SyntaxException {
        TokenList tokens = new TokenList(this.tokens);
        if (name != null && name.length() > 0) {
            tokens.add(new Token.Literal.Word(tokens.last(), name));
        }
        return new InvocationMatcher<T>(this.descriptor, tokens);
    }

    public InvocationMatcher<T> option(String optionName, List<?> optionValue) throws SyntaxException {
        return this.options(Collections.singletonMap(optionName, optionValue));
    }

    public InvocationMatcher<T> options(Map<String, List<?>> options) throws SyntaxException {
        TokenList tokens = new TokenList(this.tokens);
        for (Map.Entry<String, List<?>> option : options.entrySet()) {
            tokens.addOption(option.getKey(), option.getValue());
        }
        return new InvocationMatcher<T>(this.descriptor, tokens);
    }

    public InvocationMatch<T> arguments(List<?> arguments) throws SyntaxException {
        TokenList tokens = new TokenList(this.tokens);
        for (Object argument : arguments) {
            tokens.add(new Token.Literal.Word(tokens.last(), argument.toString()));
        }
        return this.match(tokens);
    }

    public InvocationMatch<T> parse(String s) throws SyntaxException {
        ArrayList<Token> tokens = new ArrayList<Token>();
        for (Token token : this.tokens) {
            tokens.add(token);
        }
        TokenizerImpl i = new TokenizerImpl(s);
        while (i.hasNext()) {
            tokens.add((Token)i.next());
        }
        return this.match(tokens);
    }

    private InvocationMatch<T> match(final Iterable<Token> tokens) {
        Tokenizer tokenizer = new Tokenizer(){
            Iterator<Token> i;
            {
                this.i = tokens.iterator();
            }

            @Override
            protected Token parse() {
                return this.i.hasNext() ? this.i.next() : null;
            }
        };
        return this.match(tokenizer);
    }

    private InvocationMatch<T> match(Tokenizer tokenizer) throws SyntaxException {
        InvocationMatch<T> current;
        block7: {
            Parser<T> parser = new Parser<T>(tokenizer, this.descriptor, Mode.INVOKE);
            current = new InvocationMatch<T>(this.descriptor);
            while (true) {
                Event.Argument argumentEvent;
                List values;
                Event event;
                if ((event = parser.next()) instanceof Event.Separator) {
                    continue;
                }
                if (event instanceof Event.Stop) break block7;
                if (event instanceof Event.Option) {
                    Event.Option optionEvent = (Event.Option)event;
                    OptionDescriptor desc = (OptionDescriptor)optionEvent.getParameter();
                    Collection<OptionMatch> options = current.options();
                    OptionMatch option = null;
                    for (OptionMatch om : options) {
                        if (!((OptionDescriptor)om.getParameter()).equals(desc)) continue;
                        ArrayList<LiteralValue> v = new ArrayList<LiteralValue>(om.getValues());
                        v.addAll(this.bilto(optionEvent.getValues()));
                        ArrayList<String> names = new ArrayList<String>(om.getNames());
                        names.add(optionEvent.getToken().getName());
                        option = new OptionMatch(desc, names, v);
                        break;
                    }
                    if (option == null) {
                        option = new OptionMatch(desc, optionEvent.getToken().getName(), this.bilto(optionEvent.getValues()));
                    }
                    current.option(option);
                    continue;
                }
                if (event instanceof Event.Subordinate) {
                    current = current.subordinate(((Event.Subordinate)event).getDescriptor().getName());
                    continue;
                }
                if (!(event instanceof Event.Argument) || (values = (argumentEvent = (Event.Argument)event).getValues()).size() <= 0) continue;
                ArgumentMatch match = new ArgumentMatch((ArgumentDescriptor)argumentEvent.getParameter(), argumentEvent.getFrom(), argumentEvent.getTo(), this.bilto(argumentEvent.getValues()));
                if (argumentEvent.getCommand() != current.getDescriptor()) break;
                current.argument(match);
            }
            throw new AssertionError();
        }
        StringBuilder rest = new StringBuilder();
        while (tokenizer.hasNext()) {
            Token token = tokenizer.next();
            rest.append(token.getRaw());
        }
        current.setRest(rest.toString());
        return current;
    }

    private List<LiteralValue> bilto(List<? extends Token.Literal> literals) {
        ArrayList<LiteralValue> values = new ArrayList<LiteralValue>(literals.size());
        for (Token.Literal literal : literals) {
            values.add(new LiteralValue(literal.getRaw(), literal.getValue()));
        }
        return values;
    }
}

