/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.tokenizer;

import java.util.LinkedList;
import org.crsh.cli.impl.line.LineParser;
import org.crsh.cli.impl.line.Quoting;
import org.crsh.cli.impl.tokenizer.Token;

class Automaton
extends LineParser.Visitor {
    private Status status = Status.WHITESPACE;
    private final StringBuilder buffer = new StringBuilder();
    final LinkedList<Token> tokens = new LinkedList();
    private int from = 0;
    private int lastWhitespace = 0;
    private final CharSequence s;

    Automaton(CharSequence s) {
        this.s = s;
    }

    void close() {
        if (this.buffer.length() > 0) {
            if (this.status == Status.WHITESPACE) {
                this.next(this.lastWhitespace);
            } else {
                this.next(this.s.length());
            }
        }
    }

    private void next(int current) {
        Token token;
        switch (this.status) {
            case WHITESPACE: {
                token = new Token.Whitespace(this.from, ((Object)this.s.subSequence(this.from, current)).toString());
                break;
            }
            case WORD: {
                token = new Token.Literal.Word(this.from, ((Object)this.s.subSequence(this.from, current)).toString(), this.buffer.toString());
                break;
            }
            case SHORT_OPTION: {
                token = new Token.Literal.Option.Short(this.from, ((Object)this.s.subSequence(this.from, current)).toString(), this.buffer.toString());
                break;
            }
            case LONG_OPTION: {
                token = new Token.Literal.Option.Long(this.from, ((Object)this.s.subSequence(this.from, current)).toString(), this.buffer.toString());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        this.tokens.add(token);
        this.status = Status.WHITESPACE;
        this.buffer.setLength(0);
        this.from = current;
    }

    @Override
    public void onChar(int index, Quoting quoting, boolean backslash, char c) {
        if (Character.isWhitespace(c) && quoting == null && !backslash) {
            this.lastWhitespace = index + 1;
            if (this.status != Status.WHITESPACE) {
                this.next(index);
            }
            this.buffer.append(c);
        } else {
            switch (this.status) {
                case WHITESPACE: {
                    if (this.buffer.length() > 0) {
                        this.next(this.lastWhitespace);
                    }
                    this.buffer.append(c);
                    if (c == '-') {
                        this.status = Status.SHORT_OPTION;
                        break;
                    }
                    this.status = Status.WORD;
                    break;
                }
                case WORD: {
                    this.buffer.append(c);
                    break;
                }
                case SHORT_OPTION: {
                    if (c == '-') {
                        this.buffer.append('-');
                        this.status = Status.LONG_OPTION;
                        break;
                    }
                    if (Character.isLetter(c)) {
                        this.buffer.append(c);
                        break;
                    }
                    this.status = Status.WORD;
                    this.buffer.append(c);
                    break;
                }
                case LONG_OPTION: {
                    if (c == '-') {
                        if (this.buffer.length() > 2) {
                            this.buffer.append(c);
                            break;
                        }
                        this.status = Status.WORD;
                        this.buffer.append(c);
                        break;
                    }
                    if (Character.isLetter(c)) {
                        this.buffer.append(c);
                        break;
                    }
                    this.status = Status.WORD;
                    this.buffer.append(c);
                }
            }
        }
    }

    static enum Status {
        WHITESPACE,
        WORD,
        SHORT_OPTION,
        LONG_OPTION;

    }
}

