/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sshd.ClientChannel;
import org.apache.sshd.ClientSession;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.ServerKeyVerifier;
import org.apache.sshd.client.SessionFactory;
import org.apache.sshd.client.UserAuth;
import org.apache.sshd.client.UserInteraction;
import org.apache.sshd.client.auth.UserAuthKeyboardInteractive;
import org.apache.sshd.client.auth.UserAuthPassword;
import org.apache.sshd.client.auth.UserAuthPublicKey;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.kex.DHG1;
import org.apache.sshd.client.kex.DHG14;
import org.apache.sshd.client.kex.DHGEX;
import org.apache.sshd.client.kex.DHGEX256;
import org.apache.sshd.client.kex.ECDHP256;
import org.apache.sshd.client.kex.ECDHP384;
import org.apache.sshd.client.kex.ECDHP521;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.session.ClientConnectionService;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.ClientUserAuthService;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES128CTR;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.AES256CTR;
import org.apache.sshd.common.cipher.ARCFOUR128;
import org.apache.sshd.common.cipher.ARCFOUR256;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.file.nativefs.NativeFileSystemFactory;
import org.apache.sshd.common.forward.DefaultTcpipForwarderFactory;
import org.apache.sshd.common.forward.TcpipServerChannel;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.DefaultIoServiceFactoryFactory;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.mac.HMACSHA256;
import org.apache.sshd.common.mac.HMACSHA512;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.session.AbstractSession;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureECDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.CloseableUtils;
import org.apache.sshd.common.util.NoCloseInputStream;
import org.apache.sshd.common.util.NoCloseOutputStream;
import org.apache.sshd.common.util.SecurityUtils;
import org.bouncycastle.openssl.PasswordFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
Closeable {
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected UserInteraction userInteraction;
    protected Factory<IoConnector> connectorFactory;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    private ServerKeyVerifier serverKeyVerifier;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = serverKeyVerifier;
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    protected void checkConfig() {
        if (this.getKeyExchangeFactories() == null) {
            throw new IllegalArgumentException("KeyExchangeFactories not set");
        }
        if (this.getScheduledExecutorService() == null) {
            this.setScheduledExecutorService(Executors.newSingleThreadScheduledExecutor(), true);
        }
        if (this.getCipherFactories() == null) {
            throw new IllegalArgumentException("CipherFactories not set");
        }
        if (this.getCompressionFactories() == null) {
            throw new IllegalArgumentException("CompressionFactories not set");
        }
        if (this.getMacFactories() == null) {
            throw new IllegalArgumentException("MacFactories not set");
        }
        if (this.getRandomFactory() == null) {
            throw new IllegalArgumentException("RandomFactory not set");
        }
        if (this.getTcpipForwarderFactory() == null) {
            throw new IllegalArgumentException("TcpipForwarderFactory not set");
        }
        if (this.getServerKeyVerifier() == null) {
            throw new IllegalArgumentException("ServerKeyVerifier not set");
        }
        if (this.getAgentFactory() != null) {
            List<NamedFactory<Channel>> factories = this.getChannelFactories();
            factories = factories == null ? new ArrayList<NamedFactory<Channel>>() : new ArrayList<NamedFactory<Channel>>(factories);
            factories.add(this.getAgentFactory().getChannelForwardingFactory());
            this.setChannelFactories(factories);
        }
        if (this.getIoServiceFactoryFactory() == null) {
            this.setIoServiceFactoryFactory(new DefaultIoServiceFactoryFactory());
        }
        if (this.getServiceFactories() == null) {
            this.setServiceFactories(Arrays.asList(new ClientUserAuthService.Factory(), new ClientConnectionService.Factory()));
        }
        if (this.getUserAuthFactories() == null) {
            this.setUserAuthFactories(Arrays.asList(new UserAuthPublicKey.Factory(), new UserAuthKeyboardInteractive.Factory(), new UserAuthPassword.Factory()));
        }
    }

    public void start() {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.sessionFactory.setClient(this);
        this.connector = this.createConnector();
    }

    public void stop() {
        try {
            this.close(true).await();
        }
        catch (InterruptedException e) {
            this.log.debug("Exception caught while stopping client", e);
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    public CloseFuture close(boolean immediately) {
        CloseFuture future = this.connector != null ? CloseableUtils.sequential(this.connector, this.ioServiceFactory).close(immediately) : (this.ioServiceFactory != null ? this.ioServiceFactory.close(immediately) : CloseableUtils.closed());
        future.addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture future) {
                SshClient.this.connector = null;
                SshClient.this.ioServiceFactory = null;
                if (SshClient.this.shutdownExecutor && SshClient.this.executor != null) {
                    SshClient.this.executor.shutdown();
                    SshClient.this.executor = null;
                }
            }
        });
        return future;
    }

    @Deprecated
    public ConnectFuture connect(String host, int port) throws IOException {
        return this.connect(null, host, port);
    }

    public ConnectFuture connect(String username, String host, int port) throws IOException {
        assert (host != null);
        assert (port >= 0);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        InetSocketAddress address = new InetSocketAddress(host, port);
        return this.connect(username, address);
    }

    @Deprecated
    public ConnectFuture connect(SocketAddress address) {
        return this.connect(null, address);
    }

    public ConnectFuture connect(final String username, SocketAddress address) {
        assert (address != null);
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        final DefaultConnectFuture connectFuture = new DefaultConnectFuture(null);
        this.connector.connect(address).addListener(new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                } else if (future.getException() != null) {
                    connectFuture.setException(future.getException());
                } else {
                    ClientSessionImpl session = (ClientSessionImpl)AbstractSession.getSession(future.getSession());
                    session.setUsername(username);
                    connectFuture.setSession(session);
                }
            }
        });
        return connectFuture;
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory();
    }

    public static SshClient setUpDefaultClient() {
        SshClient client = new SshClient();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            client.setKeyExchangeFactories(Arrays.asList(new DHGEX256.Factory(), new DHGEX.Factory(), new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG14.Factory(), new DHG1.Factory()));
            client.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory(), new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory()));
            client.setRandomFactory(new SingletonRandomFactory(new BouncyCastleRandom.Factory()));
        } else if (SecurityUtils.hasEcc()) {
            client.setKeyExchangeFactories(Arrays.asList(new ECDHP256.Factory(), new ECDHP384.Factory(), new ECDHP521.Factory(), new DHG1.Factory()));
            client.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory(), new SignatureECDSA.NISTP256Factory(), new SignatureECDSA.NISTP384Factory(), new SignatureECDSA.NISTP521Factory()));
            client.setRandomFactory(new SingletonRandomFactory(new JceRandom.Factory()));
        } else {
            client.setKeyExchangeFactories(Arrays.asList(new DHG1.Factory()));
            client.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory()));
            client.setRandomFactory(new SingletonRandomFactory(new JceRandom.Factory()));
        }
        SshClient.setUpDefaultCiphers(client);
        client.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
        client.setMacFactories(Arrays.asList(new HMACSHA256.Factory(), new HMACSHA512.Factory(), new HMACSHA1.Factory(), new HMACMD5.Factory(), new HMACSHA196.Factory(), new HMACMD596.Factory()));
        client.setChannelFactories(Arrays.asList(new TcpipServerChannel.ForwardedTcpipFactory()));
        client.setServerKeyVerifier(AcceptAllServerKeyVerifier.INSTANCE);
        client.setFileSystemFactory(new NativeFileSystemFactory());
        client.setTcpipForwarderFactory(new DefaultTcpipForwarderFactory());
        return client;
    }

    private static void setUpDefaultCiphers(SshClient client) {
        LinkedList<NamedFactory<Cipher>> avail = new LinkedList<NamedFactory<Cipher>>();
        avail.add(new AES128CTR.Factory());
        avail.add(new AES256CTR.Factory());
        avail.add(new ARCFOUR128.Factory());
        avail.add(new ARCFOUR256.Factory());
        avail.add(new AES128CBC.Factory());
        avail.add(new TripleDESCBC.Factory());
        avail.add(new BlowfishCBC.Factory());
        avail.add(new AES192CBC.Factory());
        avail.add(new AES256CBC.Factory());
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        client.setCipherFactories(avail);
    }

    public static void main(String[] args) throws Exception {
        ClientChannel channel;
        ConsoleHandler fh = new ConsoleHandler();
        fh.setLevel(Level.FINEST);
        fh.setFormatter(new Formatter(){

            public String format(LogRecord record) {
                String message = this.formatMessage(record);
                String throwable = "";
                if (record.getThrown() != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println();
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    throwable = sw.toString();
                }
                return String.format("%1$tY-%1$tm-%1$td: %2$-7.7s: %3$-32.32s: %4$s%5$s%n", new Date(record.getMillis()), record.getLevel().getName(), record.getLoggerName(), message, throwable);
            }
        });
        Logger root = Logger.getLogger("");
        for (Handler handler : root.getHandlers()) {
            root.removeHandler(handler);
        }
        root.addHandler(fh);
        int port = 22;
        String host = null;
        String login = System.getProperty("user.name");
        boolean agentForward = false;
        ArrayList<String> command = null;
        int logLevel = 0;
        boolean error = false;
        ArrayList<String> identities = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (command == null && "-p".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if (command == null && "-l".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    error = true;
                    break;
                }
                login = args[++i];
                continue;
            }
            if (command == null && "-v".equals(args[i])) {
                ++logLevel;
                continue;
            }
            if (command == null && "-vv".equals(args[i])) {
                logLevel += 2;
                continue;
            }
            if (command == null && "-vvv".equals(args[i])) {
                logLevel += 3;
                continue;
            }
            if ("-A".equals(args[i])) {
                agentForward = true;
                continue;
            }
            if ("-a".equals(args[i])) {
                agentForward = false;
                continue;
            }
            if ("-i".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires and argument: " + args[i]);
                    error = true;
                    break;
                }
                identities.add(args[++i]);
                continue;
            }
            if (command == null && args[i].startsWith("-")) {
                System.err.println("illegal option: " + args[i]);
                error = true;
                break;
            }
            if (host == null) {
                host = args[i];
                continue;
            }
            if (command == null) {
                command = new ArrayList<String>();
            }
            command.add(args[i]);
        }
        if (host == null) {
            System.err.println("hostname required");
            error = true;
        }
        if (error) {
            System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-l login] [-p port] hostname [command]");
            System.exit(-1);
        }
        if (logLevel <= 0) {
            root.setLevel(Level.WARNING);
        } else if (logLevel == 1) {
            root.setLevel(Level.INFO);
        } else if (logLevel == 2) {
            root.setLevel(Level.FINE);
        } else {
            root.setLevel(Level.FINEST);
        }
        KeyPairProvider provider = null;
        ArrayList<String> files = new ArrayList<String>();
        File f = new File(System.getProperty("user.home"), ".ssh/id_dsa");
        if (f.exists() && f.isFile() && f.canRead()) {
            files.add(f.getAbsolutePath());
        }
        if ((f = new File(System.getProperty("user.home"), ".ssh/id_rsa")).exists() && f.isFile() && f.canRead()) {
            files.add(f.getAbsolutePath());
        }
        if (files.size() > 0) {
            try {
                if (SecurityUtils.isBouncyCastleRegistered()) {
                    /*
                     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                     */
                    class KeyPairProviderLoader
                    implements Callable<KeyPairProvider> {
                        final /* synthetic */ List val$files;

                        KeyPairProviderLoader(List list) {
                            this.val$files = list;
                        }

                        @Override
                        public KeyPairProvider call() throws Exception {
                            return new FileKeyPairProvider(this.val$files.toArray(new String[this.val$files.size()]), new PasswordFinder(){

                                public char[] getPassword() {
                                    try {
                                        System.out.println("Enter password for private key: ");
                                        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                                        String password = r.readLine();
                                        return password.toCharArray();
                                    }
                                    catch (IOException e) {
                                        return null;
                                    }
                                }
                            });
                        }
                    }
                    provider = new KeyPairProviderLoader(files).call();
                }
            }
            catch (Throwable t) {
                System.out.println("Error loading user keys: " + t.getMessage());
            }
        }
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        client.setKeyPairProvider(provider);
        client.setUserInteraction(new UserInteraction(){

            public void welcome(String banner) {
                System.out.println(banner);
            }

            public String[] interactive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                String[] answers = new String[prompt.length];
                try {
                    for (int i = 0; i < prompt.length; ++i) {
                        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                        System.out.print(prompt[i] + " ");
                        answers[i] = r.readLine();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                return answers;
            }
        });
        ClientSession session = ((ConnectFuture)client.connect(login, host, port).await()).getSession();
        session.auth().verify();
        if (command == null) {
            channel = session.createChannel("shell");
            ((ChannelShell)channel).setAgentForwarding(agentForward);
            channel.setIn(new NoCloseInputStream(System.in));
        } else {
            channel = session.createChannel("exec");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(baos);
            for (String cmd : command) {
                ((Writer)w).append(cmd).append(" ");
            }
            ((Writer)w).append("\n");
            ((Writer)w).close();
            channel.setIn(new ByteArrayInputStream(baos.toByteArray()));
        }
        channel.setOut(new NoCloseOutputStream(System.out));
        channel.setErr(new NoCloseOutputStream(System.err));
        channel.open().await();
        channel.waitFor(2, 0L);
        session.close(false);
        client.stop();
    }
}

