/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term.processor;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.impl.line.LineParser;
import org.crsh.cli.impl.line.MultiLineVisitor;
import org.crsh.cli.spi.Completion;
import org.crsh.io.Consumer;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellProcess;
import org.crsh.telnet.term.Term;
import org.crsh.telnet.term.TermEvent;
import org.crsh.telnet.term.processor.ProcessContext;
import org.crsh.telnet.term.processor.Status;
import org.crsh.text.Chunk;
import org.crsh.text.Text;
import org.crsh.util.CloseableList;
import org.crsh.util.Utils;

public final class Processor
implements Runnable,
Consumer<Chunk> {
    private static final Text CONTINUE_PROMPT = Text.create((CharSequence)"> ");
    static final Runnable NOOP = new Runnable(){

        @Override
        public void run() {
        }
    };
    final Runnable WRITE_PROMPT_TASK = new Runnable(){

        @Override
        public void run() {
            Processor.this.writePromptFlush();
        }
    };
    final Runnable CLOSE_TASK = new Runnable(){

        @Override
        public void run() {
            Processor.this.close();
        }
    };
    private final Runnable READ_TERM_TASK = new Runnable(){

        @Override
        public void run() {
            Processor.this.readTerm();
        }
    };
    final Logger log = Logger.getLogger(Processor.class.getName());
    final Term term;
    final Shell shell;
    final LinkedList<TermEvent> queue;
    final Object lock;
    ProcessContext current;
    Status status;
    volatile boolean waitingEvent;
    private final CloseableList listeners;
    private final LineParser lineBuffer;
    private final MultiLineVisitor lineVisitor;
    private final Object termLock = new Object();
    private boolean termReading = false;

    public Processor(Term term, Shell shell) {
        this.term = term;
        this.shell = shell;
        this.queue = new LinkedList();
        this.lock = new Object();
        this.status = Status.AVAILABLE;
        this.listeners = new CloseableList();
        this.waitingEvent = false;
        this.lineVisitor = new MultiLineVisitor();
        this.lineBuffer = new LineParser(new LineParser.Visitor[]{this.lineVisitor});
    }

    public boolean isWaitingEvent() {
        return this.waitingEvent;
    }

    @Override
    public void run() {
        try {
            String welcome = this.shell.getWelcome();
            this.log.log(Level.FINE, "Writing welcome message to term");
            this.term.write((Chunk)Text.create((CharSequence)welcome));
            this.log.log(Level.FINE, "Wrote welcome message to term");
            this.writePromptFlush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        while (true) {
            try {
                while (this.iterate()) {
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean iterate() throws InterruptedException, IOException {
        Runnable runnable;
        Object object = this.lock;
        synchronized (object) {
            switch (this.status) {
                case AVAILABLE: {
                    runnable = this.peekProcess();
                    if (runnable != null) break;
                }
                case PROCESSING: 
                case CANCELLING: {
                    runnable = this.READ_TERM_TASK;
                    break;
                }
                case CLOSED: {
                    return false;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        runnable.run();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ProcessContext peekProcess() {
        while (true) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status != Status.AVAILABLE) break;
                if (this.queue.size() <= 0) break;
                TermEvent event = this.queue.removeFirst();
                if (event instanceof TermEvent.Complete) {
                    this.complete(((TermEvent.Complete)event).getLine());
                } else {
                    String line = ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                    this.lineBuffer.append((CharSequence)line);
                    if (!this.lineBuffer.crlf()) {
                        try {
                            this.term.write((Chunk)CONTINUE_PROMPT);
                            this.term.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        String command = this.lineVisitor.getRaw();
                        this.lineBuffer.reset();
                        if (command.length() > 0) {
                            this.term.addToHistory(command);
                        }
                        ShellProcess process = this.shell.createProcess(command);
                        this.current = new ProcessContext(this, process);
                        this.status = Status.PROCESSING;
                        return this.current;
                        break;
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readTerm() {
        Object object = this.termLock;
        synchronized (object) {
            if (this.termReading) {
                try {
                    this.termLock.wait();
                    return;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new AssertionError((Object)e);
                }
            }
            this.termReading = true;
        }
        try {
            Runnable runnable;
            TermEvent event = this.term.read();
            if (event instanceof TermEvent.Break) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.queue.clear();
                    if (this.status == Status.PROCESSING) {
                        this.status = Status.CANCELLING;
                        runnable = new Runnable(){
                            ProcessContext context;
                            {
                                this.context = Processor.this.current;
                            }

                            @Override
                            public void run() {
                                this.context.process.cancel();
                            }
                        };
                    } else {
                        runnable = this.status == Status.AVAILABLE ? this.WRITE_PROMPT_TASK : NOOP;
                    }
                }
            }
            if (event instanceof TermEvent.Close) {
                Object object3 = this.lock;
                synchronized (object3) {
                    this.queue.clear();
                    runnable = this.status == Status.PROCESSING ? new Runnable(){
                        ProcessContext context;
                        {
                            this.context = Processor.this.current;
                        }

                        @Override
                        public void run() {
                            this.context.process.cancel();
                            Processor.this.close();
                        }
                    } : (this.status != Status.CLOSED ? this.CLOSE_TASK : NOOP);
                    this.status = Status.CLOSED;
                }
            }
            LinkedList<TermEvent> linkedList = this.queue;
            synchronized (linkedList) {
                this.queue.addLast(event);
                runnable = NOOP;
            }
            runnable.run();
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Error when reading term", e);
        }
        finally {
            Object object4 = this.termLock;
            synchronized (object4) {
                this.termReading = false;
                this.termLock.notifyAll();
            }
        }
    }

    void close() {
        this.listeners.close();
    }

    public void addListener(Closeable listener) {
        this.listeners.add(listener);
    }

    public Class<Chunk> getConsumedType() {
        return Chunk.class;
    }

    public void provide(Chunk element) throws IOException {
        this.term.write(element);
    }

    public void flush() throws IOException {
        throw new UnsupportedOperationException("what does it mean?");
    }

    void writePromptFlush() {
        String prompt = this.shell.getPrompt();
        try {
            StringBuilder sb = new StringBuilder("\r\n");
            String p = prompt == null ? "% " : prompt;
            sb.append(p);
            CharSequence buffer = this.term.getBuffer();
            if (buffer != null) {
                sb.append(buffer);
            }
            this.term.write((Chunk)Text.create((CharSequence)sb));
            this.term.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void complete(CharSequence prefix) {
        this.log.log(Level.FINE, "About to get completions for " + prefix);
        CompletionMatch completion = this.shell.complete(((Object)prefix).toString());
        Completion completions = completion.getValue();
        this.log.log(Level.FINE, "Completions for " + prefix + " are " + completions);
        Delimiter delimiter = completion.getDelimiter();
        try {
            if (completions.getSize() != 0) {
                if (completions.getSize() == 1) {
                    Map.Entry entry = (Map.Entry)completions.iterator().next();
                    Appendable buffer = this.term.getDirectBuffer();
                    String insert = (String)entry.getKey();
                    this.term.getDirectBuffer().append(delimiter.escape((CharSequence)insert));
                    if (((Boolean)entry.getValue()).booleanValue()) {
                        buffer.append(completion.getDelimiter().getValue());
                    }
                } else {
                    String commonCompletion = Utils.findLongestCommonPrefix((Iterable)completions.getValues());
                    int width = this.term.getWidth();
                    String completionPrefix = completions.getPrefix();
                    int max = 0;
                    for (String suffix : completions.getValues()) {
                        max = Math.max(max, completionPrefix.length() + suffix.length());
                    }
                    StringBuilder sb = new StringBuilder().append('\n');
                    if ((max += 2) < width) {
                        int columns = width / max;
                        int index = 0;
                        for (String suffix : completions.getValues()) {
                            sb.append(completionPrefix).append(suffix);
                            for (int l = completionPrefix.length() + suffix.length(); l < max; ++l) {
                                sb.append(' ');
                            }
                            if (++index < columns) continue;
                            index = 0;
                            sb.append('\n');
                        }
                        if (index > 0) {
                            sb.append('\n');
                        }
                    } else {
                        Iterator i = completions.getValues().iterator();
                        while (i.hasNext()) {
                            String suffix = (String)i.next();
                            sb.append(commonCompletion).append(suffix);
                            if (!i.hasNext()) continue;
                            sb.append('\n');
                        }
                        sb.append('\n');
                    }
                    this.term.write((Chunk)Text.create((CharSequence)sb.toString()));
                    this.writePromptFlush();
                    if (commonCompletion.length() > 0) {
                        this.term.getDirectBuffer().append(delimiter.escape((CharSequence)commonCompletion));
                    }
                }
            }
        }
        catch (IOException e) {
            this.log.log(Level.SEVERE, "Could not write completion", e);
        }
    }
}

