/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.web.servlet;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;

public class Configurator
extends ServerEndpointConfig.Configurator {
    private static final Pattern cookiePattern = Pattern.compile("([^=]+)=([^\\;]*);?\\s?");

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        Map requestHeaders = request.getHeaders();
        List cookieHeaders = (List)requestHeaders.get("cookie");
        String sessionId = null;
        if (cookieHeaders != null && cookieHeaders.size() > 0) {
            for (String cookieHeader : cookieHeaders) {
                Matcher matcher = cookiePattern.matcher(cookieHeader);
                while (matcher.find()) {
                    String cookieKey = matcher.group(1);
                    String cookieValue = matcher.group(2);
                    if (!cookieKey.equals("CRASHID")) continue;
                    sessionId = cookieValue;
                }
            }
        }
        if (sessionId == null) {
            sessionId = UUID.randomUUID().toString();
            response.getHeaders().put("Set-Cookie", Collections.singletonList("CRASHID=" + sessionId + "; Path=/"));
        }
        sec.getUserProperties().put("CRASHID", sessionId);
    }
}

