/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.web.servlet;

import java.io.Flushable;
import java.io.IOException;
import java.util.EnumMap;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.text.CLS;
import org.crsh.text.Chunk;
import org.crsh.text.Color;
import org.crsh.text.Style;
import org.crsh.text.Text;
import org.crsh.util.Safe;
import org.crsh.web.servlet.CRaSHConnector;
import org.crsh.web.servlet.CRaSHSession;

public class WSProcessContext
implements ShellProcessContext {
    final ShellProcess process;
    final CRaSHSession session;
    private StringBuilder buffer = new StringBuilder();
    final int width;
    final int height;
    final String command;
    private static final EnumMap<Color, String> COLOR_MAP = new EnumMap(Color.class);
    private Style style = Style.reset;

    public WSProcessContext(CRaSHSession session, ShellProcess process, String command, int width, int height) {
        this.session = session;
        this.process = process;
        this.width = width;
        this.height = height;
        this.command = command;
    }

    public void end(ShellResponse response) {
        CRaSHConnector.log.fine("Ended \"" + this.command + "\"");
        this.session.current.compareAndSet(this, null);
        Safe.flush((Flushable)((Object)this));
        String msg = response.getMessage();
        if (msg.length() > 0) {
            this.session.send("print", msg);
        }
        String prompt = this.session.shell.getPrompt();
        this.session.send("prompt", prompt);
        this.session.send("end");
    }

    public boolean takeAlternateBuffer() throws IOException {
        return false;
    }

    public boolean releaseAlternateBuffer() throws IOException {
        return false;
    }

    public String getProperty(String propertyName) {
        return null;
    }

    public String readLine(String msg, boolean echo) {
        return null;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void write(Chunk chunk) throws IOException {
        if (chunk instanceof Style) {
            this.style = this.style.merge((Style)chunk);
        } else if (chunk instanceof Text) {
            Text text = (Text)chunk;
            CharSequence chars = text.getText();
            int length = chars.length();
            if (length > 0) {
                if (this.style.equals(Style.reset)) {
                    this.buffer.append(chars);
                } else {
                    Style.Composite composite = (Style.Composite)this.style;
                    this.buffer.append("[[");
                    if (composite.getUnderline() == Boolean.TRUE) {
                        this.buffer.append('u');
                    }
                    if (composite.getBold() == Boolean.TRUE) {
                        this.buffer.append('b');
                    }
                    this.buffer.append(';');
                    if (composite.getForeground() != null) {
                        this.buffer.append(COLOR_MAP.get(composite.getForeground()));
                    }
                    this.buffer.append(';');
                    if (composite.getBackground() != null) {
                        this.buffer.append(COLOR_MAP.get(composite.getBackground()));
                    }
                    this.buffer.append(']');
                    for (int i = 0; i < length; ++i) {
                        char c = chars.charAt(i);
                        if (c == ']') {
                            this.buffer.append("\\]");
                            continue;
                        }
                        this.buffer.append(c);
                    }
                    this.buffer.append(']');
                }
            }
        } else if (chunk instanceof CLS) {
            this.buffer.append("\u001b[");
            this.buffer.append("2J");
            this.buffer.append("\u001b[");
            this.buffer.append("1;1H");
        }
    }

    public void flush() throws IOException {
        if (this.buffer.length() > 0) {
            this.session.send("print", this.buffer.toString());
            this.buffer.setLength(0);
        }
    }

    static {
        COLOR_MAP.put(Color.black, "#000");
        COLOR_MAP.put(Color.blue, "#0000AA");
        COLOR_MAP.put(Color.cyan, "#00AAAA");
        COLOR_MAP.put(Color.green, "#00AA00");
        COLOR_MAP.put(Color.magenta, "#AA00AA");
        COLOR_MAP.put(Color.white, "#AAAAAA");
        COLOR_MAP.put(Color.yellow, "#AAAA00");
        COLOR_MAP.put(Color.red, "#AA0000");
    }
}

