/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.io.terminal.ColorHelper;
import net.wimpi.telnetd.io.toolkit.InertComponent;

public class Statusbar
extends InertComponent {
    private String m_Status;
    private int m_Align;
    private String m_BgColor;
    private String m_FgColor;
    public static final int ALIGN_RIGHT = 1;
    public static final int ALIGN_LEFT = 2;
    public static final int ALIGN_CENTER = 3;

    public Statusbar(BasicTerminalIO io, String name) {
        super(io, name);
    }

    public void setStatusText(String text) {
        this.m_Status = text;
    }

    public String getStatusText() {
        return this.m_Status;
    }

    public void setAlignment(int alignment) {
        if (alignment < 1 || alignment > 3) {
            alignment = 2;
        } else {
            this.m_Align = alignment;
        }
    }

    public void setForegroundColor(String color) {
        this.m_FgColor = color;
    }

    public void setBackgroundColor(String color) {
        this.m_BgColor = color;
    }

    public void draw() throws IOException {
        this.m_IO.storeCursor();
        this.m_IO.setCursor(this.m_IO.getRows(), 1);
        this.m_IO.write(this.getBar());
        this.m_IO.restoreCursor();
    }

    private String getBar() {
        String tstatus = this.m_Status;
        int width = this.m_IO.getColumns() - 1;
        int textwidth = (int)ColorHelper.getVisibleLength(this.m_Status);
        if (textwidth > width) {
            tstatus = this.m_Status.substring(0, width);
        }
        textwidth = (int)ColorHelper.getVisibleLength(tstatus);
        StringBuffer bar = new StringBuffer(width + textwidth);
        switch (this.m_Align) {
            case 2: {
                bar.append(tstatus);
                this.appendSpaceString(bar, width - textwidth);
                break;
            }
            case 1: {
                this.appendSpaceString(bar, width - textwidth);
                bar.append(tstatus);
                break;
            }
            case 3: {
                int left = width - textwidth != 0 ? (width - textwidth) / 2 : 0;
                int right = width - textwidth - left;
                this.appendSpaceString(bar, left);
                bar.append(tstatus);
                this.appendSpaceString(bar, right);
            }
        }
        if (this.m_FgColor != null && this.m_BgColor != null) {
            return ColorHelper.boldcolorizeText(bar.toString(), this.m_FgColor, this.m_BgColor);
        }
        if (this.m_FgColor != null && this.m_BgColor == null) {
            return ColorHelper.boldcolorizeText(bar.toString(), this.m_FgColor);
        }
        if (this.m_FgColor == null && this.m_BgColor != null) {
            return ColorHelper.colorizeBackground(bar.toString(), this.m_BgColor);
        }
        return bar.toString();
    }

    private void appendSpaceString(StringBuffer sbuf, int length) {
        for (int i = 0; i < length; ++i) {
            sbuf.append(" ");
        }
    }
}

