/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.mail;

import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.AuthenticationFailedException;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.crsh.mail.SmtpSecure;
import org.crsh.plugin.CRaSHPlugin;
import org.crsh.plugin.PropertyDescriptor;
import org.crsh.util.Strings;
import org.crsh.util.Utils;

public class MailPlugin
extends CRaSHPlugin<MailPlugin> {
    public static PropertyDescriptor<String> SMTP_HOST = new PropertyDescriptor<String>(String.class, "mail.smtp.host", "localhost", "The mail server host"){

        protected String doParse(String s) throws Exception {
            return s;
        }
    };
    public static PropertyDescriptor<Integer> SMTP_PORT = new PropertyDescriptor<Integer>(Integer.class, "mail.smtp.port", Integer.valueOf(25), "The mail server port"){

        protected Integer doParse(String s) throws Exception {
            return Integer.parseInt(s);
        }
    };
    public static PropertyDescriptor<SmtpSecure> SMTP_SECURE = new PropertyDescriptor<SmtpSecure>(SmtpSecure.class, "mail.smtp.secure", SmtpSecure.NONE, "The mail server port"){

        protected SmtpSecure doParse(String s) throws Exception {
            return SmtpSecure.valueOf(s.toUpperCase());
        }
    };
    public static PropertyDescriptor<String> SMTP_USERNAME = new PropertyDescriptor<String>(String.class, "mail.smtp.username", null, "The mail server user name"){

        protected String doParse(String s) throws Exception {
            return s;
        }
    };
    public static PropertyDescriptor<String> SMTP_PASSWORD = new PropertyDescriptor<String>(String.class, "mail.smtp.password", null, "The mail server passord", true){

        protected String doParse(String s) throws Exception {
            return s;
        }
    };
    public static PropertyDescriptor<String> SMTP_FROM = new PropertyDescriptor<String>(String.class, "mail.smtp.from", null, "The mail sender address"){

        protected String doParse(String s) throws Exception {
            return s;
        }
    };
    public static PropertyDescriptor<Boolean> DEBUG = new PropertyDescriptor<Boolean>(Boolean.class, "mail.debug", Boolean.valueOf(false), "The mail smtp debug mode"){

        protected Boolean doParse(String s) throws Exception {
            return Boolean.parseBoolean(s);
        }
    };
    private String smtpHost;
    private Integer smtpPort;
    private SmtpSecure smtpSecure;
    private String smtpUsername;
    private String smtpPassword;
    private String smtpFrom;
    private Boolean debug;

    protected Iterable<PropertyDescriptor<?>> createConfigurationCapabilities() {
        return Utils.list((Object[])new PropertyDescriptor[]{SMTP_HOST, SMTP_PORT, SMTP_SECURE, SMTP_USERNAME, SMTP_PASSWORD, SMTP_FROM, DEBUG});
    }

    public MailPlugin getImplementation() {
        return this;
    }

    public void init() {
        this.smtpHost = (String)this.getContext().getProperty(SMTP_HOST);
        this.smtpPort = (Integer)this.getContext().getProperty(SMTP_PORT);
        this.smtpSecure = (SmtpSecure)((Object)this.getContext().getProperty(SMTP_SECURE));
        this.smtpUsername = (String)this.getContext().getProperty(SMTP_USERNAME);
        this.smtpPassword = (String)this.getContext().getProperty(SMTP_PASSWORD);
        this.smtpFrom = (String)this.getContext().getProperty(SMTP_FROM);
        this.debug = (Boolean)this.getContext().getProperty(DEBUG);
    }

    public Future<Boolean> send(Iterable<String> recipients, String subject, String body, DataSource ... attachments) throws MessagingException {
        return this.send(recipients, subject, (Object)body, null, attachments);
    }

    public Future<Boolean> send(Iterable<String> recipients, final String subject, final Object body, final String type, final DataSource ... attachments) throws MessagingException {
        final InternetAddress[] addresses = InternetAddress.parse((String)Strings.join(recipients, (String)","));
        Callable<Boolean> f = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                MimeMessage bodyPart;
                Authenticator authenticator;
                Properties props = new Properties();
                props.setProperty("mail.smtp.host", MailPlugin.this.smtpHost);
                if (MailPlugin.this.smtpPort != null) {
                    props.setProperty("mail.smtp.port", Integer.toString(MailPlugin.this.smtpPort));
                }
                final String username = MailPlugin.this.smtpUsername;
                final String password = MailPlugin.this.smtpPassword;
                if (username != null && password != null) {
                    props.setProperty("mail.smtp.auth", "true");
                    authenticator = new Authenticator(){

                        protected PasswordAuthentication getPasswordAuthentication() {
                            return new PasswordAuthentication(username, password);
                        }
                    };
                } else {
                    authenticator = null;
                }
                if (Boolean.TRUE.equals(MailPlugin.this.debug)) {
                    props.setProperty("mail.debug", "true");
                }
                if (MailPlugin.this.smtpSecure != null) {
                    switch (MailPlugin.this.smtpSecure) {
                        case NONE: {
                            break;
                        }
                        case TLS: {
                            props.setProperty("mail.smtp.starttls.enable", "true");
                            break;
                        }
                        case SSL: {
                            throw new UnsupportedOperationException();
                        }
                    }
                }
                Session session = Session.getInstance((Properties)props, (Authenticator)authenticator);
                MimeMessage message = new MimeMessage(session);
                if (MailPlugin.this.smtpFrom != null) {
                    message.setFrom((Address)new InternetAddress(MailPlugin.this.smtpFrom));
                }
                message.setRecipients(Message.RecipientType.TO, (Address[])addresses);
                if (subject != null) {
                    message.setSubject(subject);
                }
                if (attachments != null && attachments.length > 0) {
                    MimeMultipart multipart = new MimeMultipart();
                    bodyPart = new MimeBodyPart();
                    bodyPart.setContent(body, type);
                    for (DataSource attachment : attachments) {
                        MimeBodyPart attachmentPart = new MimeBodyPart();
                        attachmentPart.setDataHandler(new DataHandler(attachment));
                        attachmentPart.setFileName(attachment.getName());
                        multipart.addBodyPart((BodyPart)attachmentPart);
                    }
                    message.setContent((Multipart)multipart);
                } else {
                    bodyPart = message;
                }
                if (type != null) {
                    bodyPart.setContent(body, type);
                } else {
                    bodyPart.setText(body.toString());
                }
                try {
                    Transport.send((Message)message);
                }
                catch (AuthenticationFailedException e) {
                    return false;
                }
                return true;
            }
        };
        return this.getContext().getExecutor().submit(f);
    }
}

