/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.type.ValueType;

public class CommandInfoTestCase
extends TestCase {
    public void testCommandImplicitDescription() throws IntrospectionException {
        class A {
            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandInfoTestCase.assertEquals((String)"", (String)c.getUsage());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getArguments().size());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getOptions().size());
    }

    public void testCommandDescription() throws IntrospectionException {
        class A {
            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandInfoTestCase.assertEquals((String)"", (String)c.getUsage());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getArguments().size());
        CommandInfoTestCase.assertEquals((int)0, (int)c.getOptions().size());
    }

    public void testOption() throws IntrospectionException {
        class A {
            @Option(names={"i"})
            private int i;

            A() {
            }
        }
        CommandDescriptorImpl ai = CommandFactory.DEFAULT.create(A.class);
        CommandInfoTestCase.assertEquals((int)1, (int)ai.getOptions().size());
        OptionDescriptor i = ai.getOption("-i");
        CommandInfoTestCase.assertEquals(Arrays.asList("i"), (Object)i.getNames());
    }

    public void testArgument1() throws IntrospectionException {
        class A {
            @Argument
            private int i;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandInfoTestCase.assertEquals((int)1, (int)c.getArguments().size());
        ArgumentDescriptor i = (ArgumentDescriptor)c.getArguments().get(0);
        CommandInfoTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
        CommandInfoTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        CommandInfoTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
    }

    public void testArgument2() throws IntrospectionException {
        class A {
            @Argument
            private int i;
            @Argument
            private List<Integer> j;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        CommandInfoTestCase.assertEquals((int)2, (int)c.getArguments().size());
        ArgumentDescriptor i = (ArgumentDescriptor)c.getArguments().get(0);
        CommandInfoTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
        CommandInfoTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        CommandInfoTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        ArgumentDescriptor j = (ArgumentDescriptor)c.getArguments().get(1);
        CommandInfoTestCase.assertEquals((Object)ValueType.INTEGER, (Object)j.getType());
        CommandInfoTestCase.assertEquals((Object)Multiplicity.MULTI, (Object)j.getMultiplicity());
    }

    public void testArgument3() throws IntrospectionException {
        try {
            class A {
                @Argument
                private List<Integer> i;
                @Argument
                private List<Integer> j;

                A() {
                }
            }
            CommandFactory.DEFAULT.create(A.class);
            CommandInfoTestCase.fail();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void testSub() throws IntrospectionException {
        class A {
            A() {
            }

            @Command
            void b() {
            }
        }
        CommandDescriptorImpl a = CommandFactory.DEFAULT.create(A.class);
        CommandDescriptor b = a.getSubordinate("b");
        CommandInfoTestCase.assertNotNull((Object)b);
    }

    public void testOverlappingOption() throws IntrospectionException {
        try {
            class A {
                @Option(names={"a"})
                String a;

                A() {
                }

                @Command
                void b(@Option(names={"a"}) String a) {
                }
            }
            CommandFactory.DEFAULT.create(A.class);
            CommandInfoTestCase.fail();
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
    }

    public void testAnnotation() throws IntrospectionException {
        class A {
            @Level
            String l;

            A() {
            }
        }
        CommandDescriptorImpl a = CommandFactory.DEFAULT.create(A.class);
        CommandInfoTestCase.assertEquals((int)1, (int)a.getOptions().size());
        OptionDescriptor i = a.getOption("-l");
        CommandInfoTestCase.assertEquals(Arrays.asList("l"), (Object)i.getNames());
        CommandInfoTestCase.assertTrue((boolean)(i.getAnnotation() instanceof Level));
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Option(names={"l"})
    static @interface Level {
    }
}

