/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.bootstrap;

import junit.framework.TestCase;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.descriptor.HelpDescriptor;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.InvocationMatcher;
import org.crsh.cli.impl.lang.CommandFactory;

public class BootstrapTestCase
extends TestCase {
    public void testOption() throws Exception {
        HelpDescriptor desc = new HelpDescriptor(CommandFactory.DEFAULT.create(A.class));
        OptionDescriptor help = desc.getOption("-h");
        BootstrapTestCase.assertNotNull((Object)help);
        OptionDescriptor foo = desc.getOption("-f");
        BootstrapTestCase.assertNotNull((Object)foo);
        HelpDescriptor bar = desc.getSubordinate("bar");
        OptionDescriptor barHelp = bar.getOption("-h");
        BootstrapTestCase.assertNull((Object)barHelp);
        InvocationMatcher matcher = desc.invoker("main");
        InvocationMatch match = matcher.match("");
        CommandInvoker invoker = match.getInvoker();
        invoker.invoke((Object)new A());
        match = matcher.match("-f foo_value bar");
        invoker = match.getInvoker();
        BootstrapTestCase.assertEquals((Object)"invoked:foo_value", (Object)invoker.invoke((Object)new A()));
    }

    public class A {
        @Option(names={"f", "foo"})
        String foo;

        @Command
        public String bar() {
            return "invoked:" + this.foo;
        }
    }
}

