/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl;

import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cli.Option;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.descriptor.IllegalParameterException;
import org.crsh.cli.impl.descriptor.IllegalValueTypeException;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.type.ValueType;

public class OptionTestCase
extends TestCase {
    public void testIllegalParameter() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            List<Boolean> o;

            A() {
            }
        }
        this.assertIllegalParameter(A.class);
    }

    public void testIllegalTypes() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            Exception o;

            A() {
            }
        }
        this.assertIllegalValueType(A.class);
        class B {
            @Option(names={"o"})
            List<Exception> o;

            B() {
            }
        }
        this.assertIllegalValueType(B.class);
        class C {
            @Option(names={"o"})
            double o;

            C() {
            }
        }
        this.assertIllegalValueType(C.class);
        class D {
            @Option(names={"o"})
            Double o;

            D() {
            }
        }
        this.assertIllegalValueType(D.class);
        class E {
            @Option(names={"o"})
            List<Double> o;

            E() {
            }
        }
        this.assertIllegalValueType(E.class);
    }

    public void testOptionIntType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            int o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
    }

    public void testOptionIntWrapperType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            Integer o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
    }

    public void testOptionIntListType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            List<Integer> o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.MULTI, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((Object)ValueType.INTEGER, (Object)i.getType());
    }

    public void testOptionStringType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.STRING, (Object)i.getType());
    }

    public void testOptionStringListType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            List<String> o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.MULTI, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((Object)ValueType.STRING, (Object)i.getType());
    }

    public void testOptionBooleanType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            boolean o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.BOOLEAN, (Object)i.getType());
    }

    public void testOptionBooleanWrapperType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            Boolean o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.BOOLEAN, (Object)i.getType());
    }

    public void testOptionEnumType() throws IntrospectionException {
        class A {
            @Option(names={"o"})
            RetentionPolicy o;

            A() {
            }
        }
        CommandDescriptorImpl c = CommandFactory.DEFAULT.create(A.class);
        OptionDescriptor i = c.getOption("-o");
        OptionTestCase.assertEquals((Object)Multiplicity.SINGLE, (Object)i.getMultiplicity());
        OptionTestCase.assertEquals((boolean)false, (boolean)i.isRequired());
        OptionTestCase.assertEquals((Object)ValueType.ENUM, (Object)i.getType());
    }

    public void testSingleLetterName() {
        class A {
            @Option(names={"o"})
            RetentionPolicy o;

            A() {
            }
        }
        OptionDescriptor i = CommandFactory.DEFAULT.create(A.class).getOption("-o");
        OptionTestCase.assertEquals(Arrays.asList("o"), (Object)i.getNames());
        class B {
            @Option(names={"-"})
            RetentionPolicy o;

            B() {
            }
        }
        this.assertIllegalParameter(B.class);
        class C {
            @Option(names={"_"})
            RetentionPolicy o;

            C() {
            }
        }
        this.assertIllegalParameter(C.class);
    }

    public void testTwoLettersName() {
        class A {
            @Option(names={"op"})
            RetentionPolicy o;

            A() {
            }
        }
        OptionDescriptor i = CommandFactory.DEFAULT.create(A.class).getOption("--op");
        OptionTestCase.assertEquals(Arrays.asList("op"), (Object)i.getNames());
        class B {
            @Option(names={"-o"})
            RetentionPolicy o;

            B() {
            }
        }
        this.assertIllegalParameter(B.class);
        class C {
            @Option(names={"o-"})
            RetentionPolicy o;

            C() {
            }
        }
        this.assertIllegalParameter(C.class);
    }

    public void testThreeLettersName() {
        class A {
            @Option(names={"opt"})
            RetentionPolicy o;

            A() {
            }
        }
        OptionDescriptor i = CommandFactory.DEFAULT.create(A.class).getOption("--opt");
        OptionTestCase.assertEquals(Arrays.asList("opt"), (Object)i.getNames());
        class B {
            @Option(names={"-oo"})
            RetentionPolicy o;

            B() {
            }
        }
        this.assertIllegalParameter(B.class);
        class C {
            @Option(names={"oo-"})
            RetentionPolicy o;

            C() {
            }
        }
        this.assertIllegalParameter(C.class);
        class D {
            @Option(names={"o-o"})
            RetentionPolicy o;

            D() {
            }
        }
        i = CommandFactory.DEFAULT.create(D.class).getOption("--o-o");
        OptionTestCase.assertEquals(Arrays.asList("o-o"), (Object)i.getNames());
    }

    private void assertIllegalValueType(Class<?> type) throws IntrospectionException {
        try {
            CommandFactory.DEFAULT.create(type);
            OptionTestCase.fail();
        }
        catch (IllegalValueTypeException illegalValueTypeException) {
            // empty catch block
        }
    }

    private void assertIllegalParameter(Class<?> type) throws IntrospectionException {
        try {
            CommandFactory.DEFAULT.create(type);
            OptionTestCase.fail();
        }
        catch (IllegalParameterException illegalParameterException) {
            // empty catch block
        }
    }
}

