/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.descriptor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.crsh.cli.descriptor.ArgumentDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.Multiplicity;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.lang.Util;

public abstract class CommandDescriptor<T> {
    private static final Set<String> MAIN_SINGLETON = Collections.singleton("main");
    private final String name;
    private final Description description;
    private final Map<String, OptionDescriptor> optionMap;
    private final Set<String> shortOptionNames;
    private final Set<String> longOptionNames;
    private boolean listArgument;
    private final List<OptionDescriptor> options;
    private final List<ArgumentDescriptor> arguments;
    private final List<ParameterDescriptor> parameters;
    private final Map<String, OptionDescriptor> uOptionMap;
    private final Set<String> uShortOptionNames;
    private final Set<String> uLongOptionNames;
    private final List<OptionDescriptor> uOptions;
    private final List<ArgumentDescriptor> uArguments;
    private final List<ParameterDescriptor> uParameters;

    protected CommandDescriptor(String name, Description description) throws IntrospectionException {
        this.description = description;
        this.optionMap = new LinkedHashMap<String, OptionDescriptor>();
        this.arguments = new ArrayList<ArgumentDescriptor>();
        this.options = new ArrayList<OptionDescriptor>();
        this.name = name;
        this.parameters = new ArrayList<ParameterDescriptor>();
        this.listArgument = false;
        this.shortOptionNames = new HashSet<String>();
        this.longOptionNames = new HashSet<String>();
        this.uOptionMap = Collections.unmodifiableMap(this.optionMap);
        this.uParameters = Collections.unmodifiableList(this.parameters);
        this.uOptions = Collections.unmodifiableList(this.options);
        this.uArguments = Collections.unmodifiableList(this.arguments);
        this.uShortOptionNames = this.shortOptionNames;
        this.uLongOptionNames = this.longOptionNames;
    }

    protected void addParameter(ParameterDescriptor parameter) throws IntrospectionException, NullPointerException, IllegalArgumentException {
        if (parameter == null) {
            throw new NullPointerException("No null parameter accepted");
        }
        if (parameter instanceof OptionDescriptor) {
            OptionDescriptor option = (OptionDescriptor)parameter;
            for (String optionName : option.getNames()) {
                String name;
                if (optionName.length() == 1) {
                    name = "-" + optionName;
                    this.shortOptionNames.add(name);
                } else {
                    name = "--" + optionName;
                    this.longOptionNames.add(name);
                }
                this.optionMap.put(name, option);
            }
            this.options.add(option);
            ListIterator<ParameterDescriptor> i = this.parameters.listIterator();
            while (i.hasNext()) {
                ParameterDescriptor next = i.next();
                if (!(next instanceof ArgumentDescriptor)) continue;
                i.previous();
                break;
            }
            i.add(parameter);
        } else if (parameter instanceof ArgumentDescriptor) {
            ArgumentDescriptor argument = (ArgumentDescriptor)parameter;
            if (argument.getMultiplicity() == Multiplicity.MULTI) {
                if (this.listArgument) {
                    throw new IntrospectionException();
                }
                this.listArgument = true;
            }
            this.arguments.add(argument);
            this.parameters.add(argument);
        }
    }

    public abstract Class<T> getType();

    public abstract CommandDescriptor<T> getOwner();

    public final int getDepth() {
        CommandDescriptor<T> owner = this.getOwner();
        return owner == null ? 0 : 1 + owner.getDepth();
    }

    public final void printUsage(Appendable writer) throws IOException {
        int depth = this.getDepth();
        switch (depth) {
            case 0: {
                Map<String, CommandDescriptor<T>> methods = this.getSubordinates();
                if (methods.size() == 1) {
                    methods.values().iterator().next().printUsage(writer);
                    break;
                }
                writer.append("usage: ").append(this.getName());
                for (OptionDescriptor option : this.getOptions()) {
                    option.printUsage(writer);
                }
                writer.append(" COMMAND [ARGS]\n\n");
                writer.append("The most commonly used ").append(this.getName()).append(" commands are:\n");
                String format = "   %1$-16s %2$s\n";
                for (CommandDescriptor<T> method : methods.values()) {
                    Formatter formatter = new Formatter(writer);
                    formatter.format(format, method.getName(), method.getUsage());
                }
                break;
            }
            case 1: {
                String usage;
                StringBuilder sb;
                CommandDescriptor<T> owner = this.getOwner();
                int length = 0;
                ArrayList<String> parameterUsages = new ArrayList<String>();
                ArrayList<String> parameterBilto = new ArrayList<String>();
                boolean printName = !((Object)owner.getSubordinates().keySet()).equals(MAIN_SINGLETON);
                writer.append("usage: ").append(owner.getName());
                for (OptionDescriptor option : owner.getOptions()) {
                    writer.append(" ");
                    sb = new StringBuilder();
                    option.printUsage(sb);
                    usage = sb.toString();
                    writer.append(usage);
                    length = Math.max(length, usage.length());
                    parameterUsages.add(usage);
                    parameterBilto.add(option.getUsage());
                }
                writer.append(printName ? " " + this.getName() : "");
                for (ParameterDescriptor parameter : this.getParameters()) {
                    writer.append(" ");
                    sb = new StringBuilder();
                    parameter.printUsage(sb);
                    usage = sb.toString();
                    writer.append(usage);
                    length = Math.max(length, usage.length());
                    parameterBilto.add(parameter.getUsage());
                    parameterUsages.add(usage);
                }
                writer.append("\n\n");
                String format = "   %1$-" + length + "s %2$s\n";
                for (String[] tuple : Util.tuples(String.class, parameterUsages, parameterBilto)) {
                    Formatter formatter = new Formatter(writer);
                    formatter.format(format, tuple[0], tuple[1]);
                }
                writer.append("\n\n");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Does not make sense");
            }
        }
    }

    public final void printMan(Appendable writer) throws IOException {
        int depth = this.getDepth();
        switch (depth) {
            case 0: {
                Map<String, CommandDescriptor<T>> methods = this.getSubordinates();
                if (methods.size() == 1) {
                    methods.values().iterator().next().printMan(writer);
                    break;
                }
                writer.append("NAME\n");
                writer.append(Util.MAN_TAB).append(this.getName());
                if (this.getUsage().length() > 0) {
                    writer.append(" - ").append(this.getUsage());
                }
                writer.append("\n\n");
                writer.append("SYNOPSIS\n");
                writer.append(Util.MAN_TAB).append(this.getName());
                for (OptionDescriptor option : this.getOptions()) {
                    writer.append(" ");
                    option.printUsage(writer);
                }
                writer.append(" COMMAND [ARGS]\n\n");
                String man = this.getDescription().getMan();
                if (man.length() > 0) {
                    writer.append("DESCRIPTION\n");
                    Util.indent(Util.MAN_TAB, (CharSequence)man, writer);
                    writer.append("\n\n");
                }
                if (this.getOptions().size() > 0) {
                    writer.append("PARAMETERS\n");
                    for (OptionDescriptor optionDescriptor : this.getOptions()) {
                        writer.append(Util.MAN_TAB);
                        optionDescriptor.printUsage(writer);
                        String optionText = optionDescriptor.getDescription().getBestEffortMan();
                        if (optionText.length() > 0) {
                            writer.append("\n");
                            Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)optionText, writer);
                        }
                        writer.append("\n\n");
                    }
                }
                writer.append("COMMANDS\n");
                for (CommandDescriptor commandDescriptor : methods.values()) {
                    writer.append(Util.MAN_TAB).append(commandDescriptor.getName());
                    String methodText = commandDescriptor.getDescription().getBestEffortMan();
                    if (methodText.length() > 0) {
                        writer.append("\n");
                        Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)methodText, writer);
                    }
                    writer.append("\n\n");
                }
                break;
            }
            case 1: {
                CommandDescriptor<T> owner = this.getOwner();
                boolean printName = !((Object)owner.getSubordinates().keySet()).equals(MAIN_SINGLETON);
                writer.append("NAME\n");
                writer.append(Util.MAN_TAB).append(owner.getName());
                if (printName) {
                    writer.append(" ").append(this.getName());
                }
                if (this.getUsage().length() > 0) {
                    writer.append(" - ").append(this.getUsage());
                }
                writer.append("\n\n");
                writer.append("SYNOPSIS\n");
                writer.append(Util.MAN_TAB).append(owner.getName());
                for (OptionDescriptor optionDescriptor : owner.getOptions()) {
                    writer.append(" ");
                    optionDescriptor.printUsage(writer);
                }
                if (printName) {
                    writer.append(" ").append(this.getName());
                }
                for (OptionDescriptor optionDescriptor : this.getOptions()) {
                    writer.append(" ");
                    optionDescriptor.printUsage(writer);
                }
                for (ArgumentDescriptor argumentDescriptor : this.getArguments()) {
                    writer.append(" ");
                    argumentDescriptor.printUsage(writer);
                }
                writer.append("\n\n");
                String man = this.getDescription().getMan();
                if (man.length() > 0) {
                    writer.append("DESCRIPTION\n");
                    Util.indent(Util.MAN_TAB, (CharSequence)man, writer);
                    writer.append("\n\n");
                }
                ArrayList<OptionDescriptor> arrayList = new ArrayList<OptionDescriptor>();
                arrayList.addAll(owner.getOptions());
                arrayList.addAll(this.getOptions());
                if (arrayList.size() <= 0) break;
                writer.append("\nPARAMETERS\n");
                for (ParameterDescriptor parameter : Util.join(owner.getOptions(), this.getParameters())) {
                    writer.append(Util.MAN_TAB);
                    parameter.printUsage(writer);
                    String parameterText = parameter.getDescription().getBestEffortMan();
                    if (parameterText.length() > 0) {
                        writer.append("\n");
                        Util.indent(Util.MAN_TAB_EXTRA, (CharSequence)parameterText, writer);
                    }
                    writer.append("\n\n");
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Does not make sense");
            }
        }
    }

    public abstract Map<String, ? extends CommandDescriptor<T>> getSubordinates();

    public abstract CommandDescriptor<T> getSubordinate(String var1);

    public final List<ParameterDescriptor> getParameters() {
        return this.uParameters;
    }

    public final Set<String> getOptionNames() {
        return this.uOptionMap.keySet();
    }

    public final Set<String> getShortOptionNames() {
        return this.uShortOptionNames;
    }

    public final Set<String> getLongOptionNames() {
        return this.uLongOptionNames;
    }

    public final Collection<OptionDescriptor> getOptions() {
        return this.uOptions;
    }

    public final OptionDescriptor getOption(String name) {
        return this.optionMap.get(name);
    }

    public final OptionDescriptor findOption(String name) {
        CommandDescriptor<T> owner;
        OptionDescriptor option = this.getOption(name);
        if (option == null && (owner = this.getOwner()) != null) {
            option = owner.findOption(name);
        }
        return option;
    }

    public final List<ArgumentDescriptor> getArguments() {
        return this.uArguments;
    }

    public final ArgumentDescriptor getArgument(int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index >= this.arguments.size()) {
            throw new IllegalArgumentException();
        }
        return this.arguments.get(index);
    }

    public final String getName() {
        return this.name;
    }

    public final Description getDescription() {
        return this.description;
    }

    public final String getUsage() {
        return this.description != null ? this.description.getUsage() : "";
    }
}

