/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.completers;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.crsh.cli.completers.AbstractPathCompleter;
import org.crsh.cli.spi.Completion;

public class PathCompleterTestCase
extends TestCase {
    final String sep = File.separator;
    private File root;
    private NodeCompleter completer;

    public void setUp() throws Exception {
        File tmp = File.createTempFile("crash", "");
        PathCompleterTestCase.assertTrue((boolean)tmp.delete());
        PathCompleterTestCase.assertTrue((boolean)tmp.mkdirs());
        this.root = tmp;
        this.completer = new NodeCompleter(this.root);
    }

    public void testAbsoluteFile() throws Exception {
        File foo = new File(this.root, "foo");
        PathCompleterTestCase.assertTrue((boolean)foo.createNewFile());
        this.assertCompletion(this.sep, Completion.create((String)"foo", (boolean)true));
        this.assertCompletion(this.sep + "f", Completion.create((String)"f", (String)"oo", (boolean)true));
        this.assertCompletion(this.sep + "foo", Completion.create((String)"", (boolean)true));
        PathCompleterTestCase.assertTrue((boolean)foo.delete());
        PathCompleterTestCase.assertTrue((boolean)foo.mkdirs());
        File bar = new File(foo, "bar");
        PathCompleterTestCase.assertTrue((boolean)bar.createNewFile());
        this.assertCompletion(this.sep, Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep, Completion.create((String)"bar", (boolean)true));
        this.assertCompletion(this.sep + "foo" + this.sep + "b", Completion.create((String)"b", (String)"ar", (boolean)true));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar", Completion.create((String)"", (boolean)true));
    }

    public void testAbsoluteDir() throws Exception {
        this.assertCompletion(this.sep, Completion.create());
        this.assertCompletion(this.sep + "f", Completion.create((String)"f"));
        File foo = new File(this.root, "foo");
        PathCompleterTestCase.assertTrue((boolean)foo.mkdir());
        this.assertCompletion(this.sep, Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep, Completion.create());
        File bar = new File(foo, "bar");
        PathCompleterTestCase.assertTrue((boolean)bar.mkdir());
        this.assertCompletion(this.sep, Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep, Completion.create((String)("bar" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "b", Completion.create((String)"b", (String)("ar" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar" + this.sep, Completion.create());
        File juu = new File(bar, "juu");
        PathCompleterTestCase.assertTrue((boolean)juu.mkdir());
        this.assertCompletion(this.sep, Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep, Completion.create((String)("bar" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "b", Completion.create((String)"b", (String)("ar" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar" + this.sep, Completion.create((String)("juu" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar" + this.sep + "j", Completion.create((String)"j", (String)("uu" + this.sep), (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar" + this.sep + "juu", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion(this.sep + "foo" + this.sep + "bar" + this.sep + "juu" + this.sep, Completion.create());
    }

    public void testRootRelativeDir() throws Exception {
        this.assertCompletion("", Completion.create());
        this.assertCompletion("f", Completion.create((String)"f"));
        File foo = new File(this.root, "foo");
        PathCompleterTestCase.assertTrue((boolean)foo.mkdir());
        this.assertCompletion("", Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion("f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion("foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion("foo" + this.sep, Completion.create());
        File bar = new File(foo, "bar");
        PathCompleterTestCase.assertTrue((boolean)bar.mkdir());
        this.assertCompletion("", Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion("f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion("foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion("foo" + this.sep, Completion.create((String)("bar" + this.sep), (boolean)false));
        this.assertCompletion("foo" + this.sep + "b", Completion.create((String)"b", (String)("ar" + this.sep), (boolean)false));
        this.assertCompletion("foo" + this.sep + "bar", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion("foo" + this.sep + "bar" + this.sep, Completion.create());
    }

    public void testSubRelativeDir() throws Exception {
        File sub = new File(this.root, "sub");
        PathCompleterTestCase.assertTrue((boolean)sub.mkdir());
        this.completer.setCurrent(sub);
        this.assertCompletion("", Completion.create());
        this.assertCompletion("f", Completion.create((String)"f"));
        File foo = new File(sub, "foo");
        PathCompleterTestCase.assertTrue((boolean)foo.mkdir());
        this.assertCompletion("", Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion("f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion("foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion("foo" + this.sep, Completion.create());
        File bar = new File(foo, "bar");
        PathCompleterTestCase.assertTrue((boolean)bar.mkdir());
        this.assertCompletion("", Completion.create((String)("foo" + this.sep), (boolean)false));
        this.assertCompletion("f", Completion.create((String)"f", (String)("oo" + this.sep), (boolean)false));
        this.assertCompletion("foo", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion("foo" + this.sep, Completion.create((String)("bar" + this.sep), (boolean)false));
        this.assertCompletion("foo" + this.sep + "b", Completion.create((String)"b", (String)("ar" + this.sep), (boolean)false));
        this.assertCompletion("foo" + this.sep + "bar", Completion.create((String)this.sep, (boolean)false));
        this.assertCompletion("foo" + this.sep + "bar" + this.sep, Completion.create());
    }

    private void assertCompletion(String path, Completion expected) throws Exception {
        Completion completions = this.completer.complete(null, path);
        PathCompleterTestCase.assertEquals((Object)expected, (Object)completions);
    }

    static class NodeCompleter
    extends AbstractPathCompleter<File> {
        private File current;
        private final File root;

        NodeCompleter(File root) {
            this.root = root;
            this.current = root;
        }

        public File getCurrent() {
            return this.current;
        }

        public void setCurrent(File current) throws IOException {
            if (current == null) {
                throw new AssertionFailedError("Current file should be null");
            }
            if (!current.getCanonicalPath().startsWith(this.root.getCanonicalPath())) {
                throw new AssertionFailedError("Current file should be a descendant of the root file");
            }
            this.current = current;
        }

        protected String getCurrentPath() throws Exception {
            if (this.current.equals(this.root)) {
                return File.separator;
            }
            return this.current.getCanonicalPath().substring(this.root.getCanonicalPath().length());
        }

        protected File getPath(String path) throws Exception {
            if (!path.startsWith(File.separator)) {
                throw new AssertionFailedError("Path " + path + " does not start with separator");
            }
            return new File(this.root, path.substring(1));
        }

        protected boolean exists(File path) throws Exception {
            return path.exists();
        }

        protected boolean isDirectory(File path) throws Exception {
            return path.isDirectory();
        }

        protected boolean isFile(File path) throws Exception {
            return path.isFile();
        }

        protected Collection<File> getChilren(File path) throws Exception {
            File[] files = path.listFiles();
            return files != null ? Arrays.asList(files) : null;
        }

        protected String getName(File path) throws Exception {
            return path.getName();
        }
    }
}

