/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.matcher;

import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.crsh.cli.Argument;
import org.crsh.cli.Command;
import org.crsh.cli.Option;
import org.crsh.cli.impl.Delimiter;
import org.crsh.cli.impl.completion.CompletionException;
import org.crsh.cli.impl.completion.CompletionMatch;
import org.crsh.cli.impl.completion.CompletionMatcher;
import org.crsh.cli.impl.descriptor.CommandDescriptorImpl;
import org.crsh.cli.impl.lang.CommandFactory;
import org.crsh.cli.impl.matcher.CompleterSupport;
import org.crsh.cli.impl.matcher.Custom;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;

public class CompleteTestCase
extends TestCase {
    public void testUseInstance() throws Exception {
        class Some
        extends CompleterSupport.Constant {
            Some() {
                super("bilto");
            }
        }
        Some some = new Some();
        class A {
            A() {
            }

            @Command
            void n(@Argument(completer=Some.class) String arg) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer();
        try {
            matcher.match("n b");
            CompleteTestCase.fail();
        }
        catch (CompletionException ignore) {
            // empty catch block
        }
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"ilto", (boolean)true)), (Object)matcher.match((Completer)some, "n b"));
    }

    public void testExplicitCommandSingleArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer();
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("m "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("m f"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.match("m fo"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("m a "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("m a f"));
    }

    public void testImplicitCommandSingleArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match(""));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("f"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.match("fo"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("a "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("a f"));
    }

    public void testSecondArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument String arg1, @Argument(completer=CompleterSupport.Foo.class) String arg2) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("foo "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.DOUBLE_QUOTE, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("foo \""));
    }

    public void testMultiArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void m(@Argument(completer=CompleterSupport.Foo.class) List<String> arg) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer();
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("m "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("m f"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.match("m fo"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("m a "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("m a f"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.match("m a fo"));
    }

    public void testOption() throws Exception {
        class A {
            @Option(names={"a", "add", "addition"})
            String add;

            A() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer();
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"-", (String)"a", (boolean)true)), (Object)matcher.match("-"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"", (boolean)true)), (Object)matcher.match("-a"));
        CompletionMatch a = new CompletionMatch(Delimiter.EMPTY, Completion.builder((String)"--").add("add", true).add("addition", true).build());
        CompletionMatch b = new CompletionMatch(Delimiter.EMPTY, Completion.builder((String)"--ad").add("d", true).add("dition", true).build());
        CompletionMatch c = new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"--addi", (String)"tion", (boolean)true));
        CompleteTestCase.assertEquals((Object)a, (Object)matcher.match("--"));
        CompleteTestCase.assertEquals((Object)b, (Object)matcher.match("--ad"));
        CompleteTestCase.assertEquals((Object)c, (Object)matcher.match("--addi"));
    }

    public void testDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o"}) String o, @Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("-- f"));
    }

    public void testOptionValue() throws Exception {
        class A {
            @Option(names={"a"}, completer=CompleterSupport.Foo.class)
            String a;

            A() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer();
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("-a "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("-a f"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.match("-a fo"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"-b")), (Object)matcher.match("-a -b"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("-a b "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"c")), (Object)matcher.match("-a b c"));
    }

    public void testImplicitCommandOptionName() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o", "option"}) String o) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"-", (String)"o", (boolean)true)), (Object)matcher.match("-"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"--", (String)"option", (boolean)true)), (Object)matcher.match("--"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"--o", (String)"ption", (boolean)true)), (Object)matcher.match("--o"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"--op", (String)"tion", (boolean)true)), (Object)matcher.match("--op"));
    }

    public void testOptionArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Option(names={"o"}) String o, @Argument(completer=CompleterSupport.Foo.class) String arg) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("-o bar "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("-o bar f"));
    }

    public void testCommand() throws Exception {
        class A {
            @Option(names={"a"})
            String a;

            A() {
            }

            @Command
            void foo(@Option(names={"b"}) String b) {
            }

            @Command
            void faa() {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompletionMatch a = new CompletionMatch(Delimiter.EMPTY, Completion.builder((String)"").add("foo", true).add("faa", true).build());
        CompletionMatch b = new CompletionMatch(Delimiter.EMPTY, Completion.builder((String)"f").add("oo", true).add("aa", true).build());
        CompletionMatch c = new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"", (boolean)true));
        CompletionMatch d = new CompletionMatch(Delimiter.EMPTY, Completion.create());
        CompleteTestCase.assertEquals((Object)a, (Object)matcher.match(""));
        CompleteTestCase.assertEquals((Object)b, (Object)matcher.match("f"));
        CompleteTestCase.assertEquals((Object)c, (Object)matcher.match("foo"));
        CompleteTestCase.assertEquals((Object)d, (Object)matcher.match("foo "));
        CompleteTestCase.assertEquals((Object)a, (Object)matcher.match("-a a "));
        CompleteTestCase.assertEquals((Object)b, (Object)matcher.match("-a a f"));
        CompleteTestCase.assertEquals((Object)c, (Object)matcher.match("-a a foo"));
        CompleteTestCase.assertEquals((Object)d, (Object)matcher.match("-a a foo "));
    }

    public void testArgumentValuedMain() throws Exception {
        class A {
            A() {
            }

            @Command
            void main(@Argument(completer=CompleterSupport.Echo.class) String s) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"", (boolean)false)), (Object)matcher.match(""));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"m", (boolean)false)), (Object)matcher.match("m"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"ma", (boolean)false)), (Object)matcher.match("ma"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"mai", (boolean)false)), (Object)matcher.match("mai"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"main", (boolean)false)), (Object)matcher.match("main"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("main "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("main a"));
    }

    public void testEnum() throws Exception {
        class A {
            A() {
            }

            @Command
            void foo(@Option(names={"a"}) RetentionPolicy a) {
            }

            @Command
            void bar(@Argument RetentionPolicy a) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer();
        CompletionMatch a = new CompletionMatch(Delimiter.EMPTY, Completion.builder((String)"").add("SOURCE", true).add("CLASS", true).add("RUNTIME", true).build());
        CompletionMatch b = new CompletionMatch(Delimiter.DOUBLE_QUOTE, Completion.builder((String)"").add("SOURCE", true).add("CLASS", true).add("RUNTIME", true).build());
        CompletionMatch c = new CompletionMatch(Delimiter.SINGLE_QUOTE, Completion.builder((String)"").add("SOURCE", true).add("CLASS", true).add("RUNTIME", true).build());
        CompletionMatch d = new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"SOU", (String)"RCE", (boolean)true));
        CompletionMatch e = new CompletionMatch(Delimiter.DOUBLE_QUOTE, Completion.create((String)"SOU", (String)"RCE", (boolean)true));
        CompletionMatch f = new CompletionMatch(Delimiter.SINGLE_QUOTE, Completion.create((String)"SOU", (String)"RCE", (boolean)true));
        CompletionMatch g = new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"SOURCE", (String)"", (boolean)true));
        CompletionMatch h = new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"SOURCE", (String)"", (boolean)true));
        for (String m : Arrays.asList("foo -a", "bar")) {
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)a, (Object)matcher.match(m + " "));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)b, (Object)matcher.match(m + " \""));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)c, (Object)matcher.match(m + " '"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)d, (Object)matcher.match(m + " SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)e, (Object)matcher.match(m + " \"SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)f, (Object)matcher.match(m + " 'SOU"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)g, (Object)matcher.match(m + " SOURCE"));
            CompleteTestCase.assertEquals((String)("testing " + m), (Object)h, (Object)matcher.match(m + " \"SOURCE\""));
        }
    }

    public void testCommandOption() throws Exception {
        class A {
            A() {
            }

            @Command
            void bar(@Option(names={"a"}, completer=CompleterSupport.Foo.class) String a) {
            }
        }
        CommandDescriptorImpl desc = CommandFactory.DEFAULT.create(A.class);
        CompletionMatcher matcher = desc.completer("main");
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"bar", (boolean)true)), (Object)matcher.match(""));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"b", (String)"ar", (boolean)true)), (Object)matcher.match("b"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"", (boolean)true)), (Object)matcher.match("bar"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("bar "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"foo", (boolean)true)), (Object)matcher.match("bar -a "));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"oo", (boolean)true)), (Object)matcher.match("bar -a f"));
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create((String)"o", (boolean)true)), (Object)matcher.match("bar -a fo"));
    }

    public void testFailure() throws Exception {
        class A {
            A() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.Exception.class) String a) {
            }
        }
        CompletionMatcher matcherA = CommandFactory.DEFAULT.create(A.class).completer();
        try {
            matcherA.match("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CompletionException e) {
            // empty catch block
        }
        class B {
            B() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.RuntimeException.class) String a) {
            }
        }
        CompletionMatcher matcherB = CommandFactory.DEFAULT.create(B.class).completer();
        try {
            matcherB.match("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CompletionException e) {
            // empty catch block
        }
        class C {
            C() {
            }

            @Command
            void foo(@Option(names={"a"}, completer=CompleterSupport.Abstract.class) String a) {
            }
        }
        CompletionMatcher matcherC = CommandFactory.DEFAULT.create(C.class).completer();
        try {
            matcherC.match("foo -a b");
            CompleteTestCase.fail();
        }
        catch (CompletionException e) {
            // empty catch block
        }
    }

    public void testArgumentProvidedValue() throws Exception {
        class A {
            Custom o;

            A() {
            }

            @Command
            public void foo(@Argument Custom o) {
                this.o = o;
            }
        }
        CommandDescriptorImpl desc = new CommandFactory(CompleteTestCase.class.getClassLoader()).create(A.class);
        CompletionMatcher matcher = desc.completer();
        CompleteTestCase.assertEquals((Object)new CompletionMatch(Delimiter.EMPTY, Completion.create()), (Object)matcher.match("foo "));
    }
}

