/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.matcher;

import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.spi.Completer;
import org.crsh.cli.spi.Completion;

public class CompleterSupport {

    public static abstract class Constant
    implements Completer {
        private final String value;

        public Constant(String value) {
            this.value = value;
        }

        public Completion complete(ParameterDescriptor parameter, String prefix) {
            if (this.value.startsWith(prefix)) {
                return Completion.create((String)this.value.substring(prefix.length()), (boolean)true);
            }
            return Completion.create();
        }
    }

    public static class Foo
    extends Constant {
        public Foo() {
            super("foo");
        }
    }

    public static class Echo
    implements Completer {
        public Completion complete(ParameterDescriptor parameter, String prefix) {
            return Completion.create((String)prefix, (boolean)false);
        }
    }

    public static class Mirror
    implements Completer {
        public Completion complete(ParameterDescriptor parameter, String prefix) {
            return Completion.create((String)new StringBuilder(prefix).reverse().toString(), (boolean)false);
        }
    }

    public static class Exception
    implements Completer {
        public Completion complete(ParameterDescriptor parameter, String prefix) throws java.lang.Exception {
            throw new java.lang.Exception();
        }
    }

    public static class RuntimeException
    implements Completer {
        public Completion complete(ParameterDescriptor parameter, String prefix) throws java.lang.Exception {
            throw new java.lang.RuntimeException();
        }
    }

    public static abstract class Abstract
    implements Completer {
    }
}

