/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline;

import java.lang.reflect.Constructor;
import org.crsh.cmdline.EmptyCompleter;
import org.crsh.cmdline.EnumCompleter;
import org.crsh.cmdline.spi.Completer;
import org.crsh.cmdline.spi.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleValueType<T> {
    public static final SimpleValueType<String> STRING = new SimpleValueType<String>(String.class, EmptyCompleter.class){

        @Override
        public <S extends String> String parse(Class<S> type, String s) {
            return s;
        }
    };
    public static final SimpleValueType<Integer> INTEGER = new SimpleValueType<Integer>(Integer.class, EmptyCompleter.class){

        @Override
        public <S extends Integer> Integer parse(Class<S> type, String s) {
            return Integer.parseInt(s);
        }
    };
    public static final SimpleValueType<Boolean> BOOLEAN = new SimpleValueType<Boolean>(Boolean.class, EmptyCompleter.class){

        @Override
        public <S extends Boolean> Boolean parse(Class<S> type, String s) {
            return Boolean.parseBoolean(s);
        }
    };
    public static final SimpleValueType<Enum> ENUM = new SimpleValueType<Enum>(Enum.class, EnumCompleter.class){

        @Override
        public <S extends Enum> Enum parse(Class<S> type, String s) {
            return Enum.valueOf(type, s);
        }
    };
    public static final SimpleValueType<Value> VALUE = new SimpleValueType<Value>(Value.class, null){

        @Override
        public <S extends Value> Value parse(Class<S> type, String s) throws Exception {
            Constructor<S> ctor = type.getConstructor(String.class);
            return (Value)ctor.newInstance(s);
        }
    };
    private static final SimpleValueType<?>[] types = new SimpleValueType[]{STRING, INTEGER, BOOLEAN, ENUM, VALUE};
    private final Class<T> javaType;
    private final Class<? extends Completer> completer;

    public static SimpleValueType<?> get(Class<?> clazz) {
        SimpleValueType<?> bestType = null;
        int bestDegree = Integer.MAX_VALUE;
        for (SimpleValueType<?> type : types) {
            int degree = type.getRelativeDegree(clazz);
            if (degree == -1 || degree >= bestDegree) continue;
            bestType = type;
            bestDegree = degree;
        }
        return bestType;
    }

    private SimpleValueType(Class<T> javaType, Class<? extends Completer> completer) {
        if (javaType == null) {
            throw new NullPointerException();
        }
        this.completer = completer;
        this.javaType = javaType;
    }

    public int getRelativeDegree(Class<?> clazz) {
        if (this.javaType == clazz) {
            return 0;
        }
        if (this.javaType.isAssignableFrom(clazz)) {
            int degree = 0;
            for (Class<?> current = clazz; current != this.javaType; current = current.getSuperclass()) {
                ++degree;
            }
            return degree;
        }
        return -1;
    }

    public Class<? extends Completer> getCompleter() {
        return this.completer;
    }

    public Class<T> getJavaType() {
        return this.javaType;
    }

    public abstract <S extends T> T parse(Class<S> var1, String var2) throws Exception;
}

