/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import junit.framework.TestCase;
import org.crsh.cmdline.matcher.impl.Termination;
import org.crsh.cmdline.matcher.impl.Token;
import org.crsh.cmdline.matcher.impl.Tokenizer;

public class TokenizerTestCase
extends TestCase {
    public void testEmpty() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"");
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testSpace() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)" ");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testWord1() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a"), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testWord2() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)" a");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(1, "a"), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testQuotedWord1() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"\"a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"a", "a", Termination.DOUBLE_QUOTE), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testQuotedWord2() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"\"a \"");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "\"a \"", "a ", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testQuotedWord3() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"a\" \"b");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a\" \"b", "a b", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testEmptyShortOption() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"-");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "-", "-", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testShortOption1() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"-a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(0, "-a", "-a", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testShortOption2() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)" -a");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Short(1, "-a", "-a", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testEmptyLongOption() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"--");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "--", "--", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testLongOption1() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"--a");
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(0, "--a", "--a", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testLongOption2() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)" --a");
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(0, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Option.Long(1, "--a", "--a", Termination.DETERMINED), (Object)tokenizer.next());
        TokenizerTestCase.assertFalse((boolean)tokenizer.hasNext());
    }

    public void testIndex() throws Exception {
        Tokenizer tokenizer = new Tokenizer((CharSequence)"a b");
        TokenizerTestCase.assertEquals((int)0, (int)tokenizer.getIndex());
        TokenizerTestCase.assertEquals((Object)new Token.Literal.Word(0, "a"), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((int)1, (int)tokenizer.getIndex());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(1, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((int)2, (int)tokenizer.getIndex());
        tokenizer.pushBack(1);
        TokenizerTestCase.assertEquals((int)1, (int)tokenizer.getIndex());
        TokenizerTestCase.assertEquals((Object)new Token.Whitespace(1, " "), (Object)tokenizer.next());
        TokenizerTestCase.assertEquals((int)2, (int)tokenizer.getIndex());
    }
}

