/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Required;
import org.crsh.cmdline.matcher.CmdLineException;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.Matcher;
import org.crsh.cmdline.matcher.ValueSupport;

public class MatcherTestCase
extends TestCase {
    public void testRequiredClassOption() throws Exception {
        class A {
            @Option(names={"o"})
            @Required
            String s;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        analyzer.match("-o foo").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        try {
            a = new A();
            analyzer.match("").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.fail();
        }
        catch (CmdSyntaxException e) {
            // empty catch block
        }
    }

    public void testOptionalClassOption() throws Exception {
        class A {
            @Option(names={"o"})
            String s;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        analyzer.match("-o foo").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        a = new A();
        analyzer.match("").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
    }

    public void testPrimitiveClassArgument() throws Exception {
        class A {
            @Argument
            int i;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        analyzer.match("5").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new A();
        analyzer.match("5 6").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new A();
        a.i = -3;
        analyzer.match("").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((int)-3, (int)a.i);
    }

    public void testPrimitiveMethodArgument() throws Exception {
        ClassDescriptor desc = CommandFactory.create(PMA.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        PMA a = new PMA();
        analyzer.match("m 5").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new PMA();
        analyzer.match("m 5 6").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((int)5, (int)a.i);
        a = new PMA();
        try {
            analyzer.match("m").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.fail();
        }
        catch (CmdSyntaxException e) {
            // empty catch block
        }
    }

    public void testOptionalClassArgument() throws Exception {
        class A {
            @Argument
            String s;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        analyzer.match("foo").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        a = new A();
        analyzer.match("foo bar").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        a = new A();
        analyzer.match("").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
    }

    public void testOptionalArgumentList() throws Exception {
        ClassDescriptor desc = CommandFactory.create(BC.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        for (String s : Arrays.asList("", "bar ")) {
            BC a = new BC();
            analyzer.match(s + "").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.assertEquals(null, a.s);
            a = new BC();
            analyzer.match(s + "foo").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.assertEquals(Arrays.asList("foo"), a.s);
            a = new BC();
            analyzer.match(s + "foo bar").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.assertEquals(Arrays.asList("foo", "bar"), a.s);
            a = new BC();
            analyzer.match(s + "foo ").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.assertEquals(Arrays.asList("foo"), a.s);
        }
    }

    public void testRequiredArgumentList() throws Exception {
        class A {
            @Argument
            @Required
            List<String> s;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        try {
            analyzer.match("").invoke(new InvocationContext(), (Object)a);
            MatcherTestCase.fail();
        }
        catch (CmdSyntaxException expected) {
            // empty catch block
        }
        a = new A();
        analyzer.match("foo").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(Arrays.asList("foo"), a.s);
        a = new A();
        analyzer.match("foo bar").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(Arrays.asList("foo", "bar"), a.s);
    }

    public void testMethodInvocation() throws Exception {
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        analyzer.match("-s foo m -o bar juu").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((String)"foo", (String)a.s);
        MatcherTestCase.assertEquals((String)"bar", (String)a.o);
        MatcherTestCase.assertEquals((String)"juu", (String)a.a);
        a = new A();
        analyzer.match("m -o bar juu").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals((String)"bar", (String)a.o);
        MatcherTestCase.assertEquals((String)"juu", (String)a.a);
        a = new A();
        analyzer.match("m juu").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals(null, (String)a.o);
        MatcherTestCase.assertEquals((String)"juu", (String)a.a);
        a = new A();
        analyzer.match("m -o bar").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals((String)"bar", (String)a.o);
        MatcherTestCase.assertEquals(null, (String)a.a);
        a = new A();
        analyzer.match("m").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals(null, (String)a.s);
        MatcherTestCase.assertEquals(null, (String)a.o);
        MatcherTestCase.assertEquals(null, (String)a.a);
    }

    public void testMainMethodInvocation() throws Exception {
        ClassDescriptor desc = CommandFactory.create(B.class);
        Matcher analyzer = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        B b = new B();
        analyzer.match("").invoke(new InvocationContext(), (Object)b);
        MatcherTestCase.assertEquals((int)1, (int)b.count);
    }

    public void testInvocationAttributeInjection() throws Exception {
        ClassDescriptor desc = CommandFactory.create(C.class);
        Matcher analyzer = Matcher.createMatcher((String)"main", (ClassDescriptor)desc);
        C c = new C();
        InvocationContext context = new InvocationContext();
        context.setAttribute(Locale.class, (Object)Locale.FRENCH);
        analyzer.match("").invoke(context, (Object)c);
        MatcherTestCase.assertEquals((Object)Locale.FRENCH, (Object)c.locale);
    }

    public void testInvocationTypeConversionInjection() throws Exception {
        ClassDescriptor desc = CommandFactory.create(D.class);
        D d = new D();
        InvocationContext context = new InvocationContext();
        Matcher.createMatcher((String)"a", (ClassDescriptor)desc).match("-o 5").invoke(context, (Object)d);
        MatcherTestCase.assertEquals((Object)5, (Object)d.i);
        d = new D();
        Matcher.createMatcher((String)"b", (ClassDescriptor)desc).match("-o 5").invoke(context, (Object)d);
        MatcherTestCase.assertEquals((Object)5, (Object)d.i);
    }

    public void testQuoted() throws Exception {
        ClassDescriptor desc = CommandFactory.create(E.class);
        E e = new E();
        InvocationContext context = new InvocationContext();
        Matcher.createMatcher((String)"a", (ClassDescriptor)desc).match("-o a").invoke(context, (Object)e);
        MatcherTestCase.assertEquals((String)"a", (String)e.i);
        e = new E();
        context = new InvocationContext();
        Matcher.createMatcher((String)"a", (ClassDescriptor)desc).match("-o \"a\"").invoke(context, (Object)e);
        MatcherTestCase.assertEquals((String)"\"a\"", (String)e.i);
    }

    public void testOptionList() throws Exception {
        ClassDescriptor desc = CommandFactory.create(F.class);
        F f = new F();
        InvocationContext context = new InvocationContext();
        Matcher.createMatcher((String)"foo", (ClassDescriptor)desc).match("-o a").invoke(context, (Object)f);
        MatcherTestCase.assertEquals(Arrays.asList("a"), f.s);
        f = new F();
        context = new InvocationContext();
        Matcher.createMatcher((String)"foo", (ClassDescriptor)desc).match("-o a -o b").invoke(context, (Object)f);
        MatcherTestCase.assertEquals(Arrays.asList("a", "b"), f.s);
    }

    public void testValue() throws Exception {
        ClassDescriptor desc = CommandFactory.create(G.class);
        G g = new G();
        InvocationContext context = new InvocationContext();
        Matcher.createMatcher((String)"foo", (ClassDescriptor)desc).match("-o a").invoke(context, (Object)g);
        MatcherTestCase.assertEquals((Object)((Object)new ValueSupport.Provided("a")), (Object)((Object)g.o));
    }

    public void testException() throws Exception {
        ClassDescriptor desc = CommandFactory.create(H.class);
        H h = new H();
        InvocationContext context = new InvocationContext();
        CommandMatch match = Matcher.createMatcher((String)"foo", (ClassDescriptor)desc).match("");
        try {
            match.invoke(context, (Object)h);
            MatcherTestCase.fail();
        }
        catch (CmdLineException e) {
            MatcherTestCase.assertEquals(Exception.class, e.getCause().getClass());
            MatcherTestCase.assertEquals((String)"fooexception", (String)e.getCause().getMessage());
        }
    }

    public void testRuntimeException() throws Exception {
        ClassDescriptor desc = CommandFactory.create(I.class);
        I i = new I();
        InvocationContext context = new InvocationContext();
        CommandMatch match = Matcher.createMatcher((String)"foo", (ClassDescriptor)desc).match("");
        try {
            match.invoke(context, (Object)i);
            MatcherTestCase.fail();
        }
        catch (CmdLineException e) {
            MatcherTestCase.assertEquals(RuntimeException.class, e.getCause().getClass());
            MatcherTestCase.assertEquals((String)"fooruntimeexception", (String)e.getCause().getMessage());
        }
    }

    public void testError() throws Exception {
        ClassDescriptor desc = CommandFactory.create(J.class);
        J j = new J();
        InvocationContext context = new InvocationContext();
        CommandMatch match = Matcher.createMatcher((String)"foo", (ClassDescriptor)desc).match("");
        try {
            match.invoke(context, (Object)j);
            MatcherTestCase.fail();
        }
        catch (Error e) {
            MatcherTestCase.assertEquals((String)"fooerror", (String)e.getMessage());
        }
    }

    public void testBooleanParameter() throws Exception {
        class A {
            @Option(names={"o"})
            boolean o;

            A() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(A.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        A a = new A();
        analyzer.match("-o").invoke(new InvocationContext(), (Object)a);
        MatcherTestCase.assertEquals((boolean)true, (boolean)a.o);
    }

    public void testSCP() throws Exception {
        class SCP {
            @Option(names={"t"})
            boolean t;
            @Argument
            @Required
            String target;

            SCP() {
            }
        }
        ClassDescriptor desc = CommandFactory.create(SCP.class);
        Matcher analyzer = Matcher.createMatcher((ClassDescriptor)desc);
        SCP scp = new SCP();
        CommandMatch matcher = analyzer.match("-t -- portal:collaboration:/Documents");
        matcher.invoke(new InvocationContext(), (Object)scp);
        MatcherTestCase.assertEquals((boolean)true, (boolean)scp.t);
        MatcherTestCase.assertEquals((String)"portal:collaboration:/Documents", (String)scp.target);
        scp = new SCP();
        matcher = analyzer.match("-t");
        try {
            matcher.invoke(new InvocationContext(), (Object)scp);
            MatcherTestCase.fail();
        }
        catch (CmdLineException e) {
            // empty catch block
        }
    }

    public static class J {
        @Command
        public void foo() {
            throw new Error("fooerror");
        }
    }

    public static class I {
        @Command
        public void foo() {
            throw new RuntimeException("fooruntimeexception");
        }
    }

    public static class H {
        @Command
        public void foo() throws Exception {
            throw new Exception("fooexception");
        }
    }

    public static class G {
        ValueSupport.Provided o;

        @Command
        public void foo(@Option(names={"o"}) ValueSupport.Provided o) {
            this.o = o;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class F {
        List<String> s;

        @Command
        public void foo(@Option(names={"o"}) List<String> s) {
            this.s = s;
        }
    }

    public static class E {
        private String i;

        @Command
        public void a(@Option(names={"o"}, unquote=false) String i) {
            this.i = i;
        }
    }

    public static class D {
        private Integer i;

        @Command
        public void a(@Option(names={"o"}) Integer i) {
            this.i = i;
        }

        @Command
        public void b(@Option(names={"o"}) int i) {
            this.i = i;
        }
    }

    public static class C {
        Locale locale;

        @Command
        public void main(Locale locale) {
            this.locale = locale;
        }
    }

    public static class B {
        int count;

        @Command
        public void main() {
            ++this.count;
        }
    }

    public static class A {
        @Option(names={"s"})
        String s;
        String o;
        String a;

        @Command
        public void m(@Option(names={"o"}) String o, @Argument String a) {
            this.o = o;
            this.a = a;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BC {
        @Argument
        List<String> s;

        @Command
        public void bar(@Argument List<String> s) {
            this.s = s;
        }
    }

    public static class PMA {
        int i;

        @Command
        public void m(@Argument int i) {
            this.i = i;
        }
    }
}

