/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.ParameterDescriptor;
import org.crsh.cmdline.binding.ClassFieldBinding;
import org.crsh.cmdline.matcher.ArgumentMatch;
import org.crsh.cmdline.matcher.CmdInvocationException;
import org.crsh.cmdline.matcher.CmdLineException;
import org.crsh.cmdline.matcher.CmdSyntaxException;
import org.crsh.cmdline.matcher.CommandMatch;
import org.crsh.cmdline.matcher.InvocationContext;
import org.crsh.cmdline.matcher.OptionMatch;
import org.crsh.cmdline.matcher.ParameterMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMatch<T>
extends CommandMatch<T, ClassDescriptor<T>, ClassFieldBinding> {
    private final ClassDescriptor<T> descriptor;

    public ClassMatch(ClassDescriptor<T> descriptor, List<OptionMatch<ClassFieldBinding>> optionMatches, List<ArgumentMatch<ClassFieldBinding>> argumentMatches, String rest) {
        super(optionMatches, argumentMatches, rest);
        this.descriptor = descriptor;
    }

    @Override
    public ClassDescriptor<T> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void printMan(Appendable writer) throws IOException {
        this.descriptor.printMan(writer);
    }

    @Override
    public void printUsage(Appendable writer) throws IOException {
        this.descriptor.printUsage(writer);
    }

    @Override
    public Set<ParameterDescriptor<?>> getParameters() {
        HashSet unused = new HashSet();
        unused.addAll(this.descriptor.getArguments());
        unused.addAll(this.descriptor.getOptions());
        return unused;
    }

    @Override
    public List<ParameterMatch<?, ?>> getParameterMatches() {
        ArrayList matches = new ArrayList();
        matches.addAll(this.getOptionMatches());
        matches.addAll(this.getArgumentMatches());
        return matches;
    }

    @Override
    protected Object doInvoke(InvocationContext context, T command, Map<ParameterDescriptor<?>, Object> values) throws CmdLineException {
        for (ParameterDescriptor parameter : this.descriptor.getParameters()) {
            Object value = values.get(parameter);
            if (value == null) {
                if (!parameter.isRequired()) continue;
                throw new CmdSyntaxException("Non satisfied parameter " + parameter);
            }
            Field f = ((ClassFieldBinding)parameter.getBinding()).getField();
            try {
                f.setAccessible(true);
                f.set(command, value);
            }
            catch (Exception e) {
                throw new CmdInvocationException(e.getMessage(), e);
            }
        }
        return null;
    }
}

