/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.matcher.impl;

import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.crsh.cmdline.ArgumentDescriptor;
import org.crsh.cmdline.ClassDescriptor;
import org.crsh.cmdline.CommandFactory;
import org.crsh.cmdline.OptionDescriptor;
import org.crsh.cmdline.annotations.Argument;
import org.crsh.cmdline.annotations.Command;
import org.crsh.cmdline.annotations.Option;
import org.crsh.cmdline.annotations.Required;
import org.crsh.cmdline.matcher.impl.Event;
import org.crsh.cmdline.matcher.impl.Mode;
import org.crsh.cmdline.matcher.impl.Parser;
import org.crsh.cmdline.matcher.tokenizer.Tokenizer;

public class ParserTestCase
extends TestCase {
    public void testUnkownClassOption() throws Exception {
        class A {
            A() {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.Class.class, 0);
    }

    public void testUnkownMethodOption1() throws Exception {
        class A {
            A() {
            }

            @Command
            void main() {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.Method.class, 0);
    }

    public void testUnkownMethodOption2() throws Exception {
        class A {
            A() {
            }

            @Command
            void m() {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "m -o");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.Method.class, 2);
    }

    public void testClassOption() throws Exception {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-o ");
        tester.assertOption("o", new String[0]);
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Option.class, 3);
        tester = new Tester(cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-o a b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
    }

    public void testMethodOption() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertMethod("main");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-o a");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-o a b");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
    }

    public void testClassOptionList() throws Exception {
        class A {
            @Option(names={"o"})
            List<String> o;

            A() {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-o a -o b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("o", "b");
        tester.assertEnd(Event.Stop.Done.Option.class, 9);
    }

    public void testMethodOptionList() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) List<String> o) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertMethod("main");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-o a");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-o a -o b");
        tester.assertMethod("main");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("o", "b");
        tester.assertEnd(Event.Stop.Done.Option.class, 9);
    }

    public void testOptions1() throws Exception {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }

            @Command
            public void main(@Option(names={"p"}) String p) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-o a b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
        tester = new Tester(cmd, "-p");
        tester.assertMethod("main");
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-p a");
        tester.assertMethod("main");
        tester.assertOption("p", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-p a b");
        tester.assertMethod("main");
        tester.assertOption("p", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
        tester = new Tester(cmd, "-o -p");
        tester.assertOption("o", new String[0]);
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 5);
        tester = new Tester(cmd, "-o a -p");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 7);
        tester = new Tester(cmd, "-o a -p b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("main");
        tester.assertOption("p", "b");
        tester.assertEnd(Event.Stop.Done.Option.class, 9);
    }

    public void testOptions2() throws Exception {
        class A {
            @Option(names={"o"})
            String o;

            A() {
            }

            @Command
            public void m(@Option(names={"p"}) String p) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "-o");
        tester.assertOption("o", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 2);
        tester = new Tester(cmd, "-o a");
        tester.assertOption("o", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "-o a b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 5);
        tester = new Tester(cmd, "m -p");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 4);
        tester = new Tester(cmd, "m -p a");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", "a");
        tester.assertEnd(Event.Stop.Done.Option.class, 6);
        tester = new Tester(cmd, "m -p a b");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 7);
        tester = new Tester(cmd, "-o a m -p");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 9);
        tester = new Tester(cmd, "-o a m -p b");
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("p", "b");
        tester.assertEnd(Event.Stop.Done.Option.class, 11);
        tester = new Tester(cmd, "m -o a -p");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("p", new String[0]);
        tester.assertEnd(Event.Stop.Done.Option.class, 9);
        tester = new Tester(cmd, "m -o a -p b");
        tester.assertMethod("m");
        tester.assertSeparator();
        tester.assertOption("o", "a");
        tester.assertSeparator();
        tester.assertOption("p", "b");
        tester.assertEnd(Event.Stop.Done.Option.class, 11);
    }

    public void testClassArgument() throws Exception {
        class A {
            @Argument(name="arg")
            String arg;

            A() {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a");
        tester.assertArgument("arg", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b");
        tester.assertArgument("arg", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 2);
    }

    public void testMethodArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Unresolved.TooManyArguments.class, 2);
    }

    public void testSatisfyAllMethodArgument() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 2);
    }

    public void testMethodArgumentList() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="args") List<String> args) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a ");
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 2);
        tester = new Tester(cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
        tester = new Tester(cmd, "a b ");
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 4);
    }

    public void testSatisfyAllMethodArgumentList() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="args") List<String> args) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a ", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 2);
        tester = new Tester(cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
        tester = new Tester(cmd, "a b ", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("args", "a", "b");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 4);
    }

    public void testMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") String arg1, @Argument(name="arg2") String arg2) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
    }

    public void testSatisfyAllMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") String arg1, @Argument(name="arg2") String arg2) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
    }

    public void testRequiredMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Required @Argument(name="arg1") String arg1, @Required @Argument(name="arg2") String arg2) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
    }

    public void testSatisfyAllRequiredMethodArguments() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Required @Argument(name="arg1") String arg1, @Required @Argument(name="arg2") String arg2) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
    }

    public void testMixedMethodArguments() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") List<String> arg1, @Argument(name="arg2") String arg2) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b");
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
    }

    public void testSatisfyAllMixedMethodArguments() throws Exception {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg1") List<String> arg1, @Argument(name="arg2") String arg2) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "a", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg2", "a");
        tester.assertEnd(Event.Stop.Done.Arg.class, 1);
        tester = new Tester(cmd, "a b", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg1", "a");
        tester.assertSeparator();
        tester.assertArgument("arg2", "b");
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
    }

    public void testExplicitMainMethod() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "main");
        tester.assertMethod("main");
        tester.assertArgument("arg", "main");
        tester.assertEnd(Event.Stop.Done.Arg.class, 4);
    }

    public void testSatisfyAllExplicitMainMethod() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Argument(name="arg") String arg) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "main", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertArgument("arg", "main");
        tester.assertEnd(Event.Stop.Done.Arg.class, 4);
    }

    public void testDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o, @Argument(name="arg") String arg) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "--", Mode.COMPLETE);
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Unresolved.NoSuchOption.Method.class, 0);
        tester = new Tester(cmd, "-- ", Mode.COMPLETE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
        tester = new Tester(cmd, "-- foo", Mode.COMPLETE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertArgument("arg", "foo");
        tester.assertEnd(Event.Stop.Done.Arg.class, 6);
    }

    public void testSatisfyAllDoubleDash() throws Exception {
        class A {
            A() {
            }

            @Command
            public void main(@Option(names={"o"}) String o, @Argument(name="arg") String arg) {
            }
        }
        ClassDescriptor cmd = CommandFactory.create(A.class);
        Tester tester = new Tester(cmd, "--", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertEnd(Event.Stop.Done.Arg.class, 2);
        tester = new Tester(cmd, "-- ", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertEnd(Event.Stop.Done.Arg.class, 3);
        tester = new Tester(cmd, "-- foo", Mode.INVOKE);
        tester.assertMethod("main");
        tester.assertSeparator();
        tester.assertArgument("arg", "foo");
        tester.assertEnd(Event.Stop.Done.Arg.class, 6);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Tester<T> {
        private final ClassDescriptor<T> command;
        private Parser parser;

        private Tester(ClassDescriptor<T> command, String s) {
            this(command, s, Mode.COMPLETE);
        }

        private Tester(ClassDescriptor<T> command, String s, Mode mode) {
            this.command = command;
            this.parser = new Parser(new Tokenizer((CharSequence)s), command, "main", mode);
        }

        public void assertSeparator() {
            Event event = this.parser.next();
            Assert.assertTrue((String)("was expecting a separator instead of " + event), (boolean)(event instanceof Event.Separator));
        }

        public void assertMethod(String name) {
            Event.Method event = (Event.Method)this.parser.next();
            Assert.assertEquals((String)name, (String)event.getDescriptor().getName());
        }

        public void assertOption(String name, String ... values) {
            Event.Option event = (Event.Option)this.parser.next();
            Assert.assertTrue((boolean)((OptionDescriptor)event.getDescriptor()).getNames().contains(name));
            Assert.assertEquals(Arrays.asList(values), (Object)event.getStrings());
        }

        public void assertArgument(String name, String ... values) {
            Event.Argument event = (Event.Argument)this.parser.next();
            Assert.assertEquals((String)name, (String)((ArgumentDescriptor)event.getDescriptor()).getName());
            Assert.assertEquals(Arrays.asList(values), (Object)event.getStrings());
        }

        public void assertEnd(Class expectedClass, int expectedIndex) {
            Event.Stop event = (Event.Stop)this.parser.next();
            Assert.assertEquals((Object)expectedClass, event.getClass());
            Assert.assertEquals((int)expectedIndex, (int)event.getIndex());
        }
    }
}

