/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cmdline.completers;

import junit.framework.TestCase;
import org.crsh.cmdline.completers.JNDICompleter;
import org.crsh.cmdline.spi.ValueCompletion;

public class JNDICompleterTestCase
extends TestCase {
    private JNDICompleter completer;

    protected void setUp() throws Exception {
        this.completer = new JNDICompleter();
    }

    private ValueCompletion getValueCompletionComplete(String prefix) {
        ValueCompletion valueCompletion = null;
        try {
            valueCompletion = this.completer.complete(null, prefix);
        }
        catch (Exception e) {
            e.printStackTrace();
            JNDICompleterTestCase.fail((String)"complete() method shouldn't throw an exeption");
        }
        return valueCompletion;
    }

    public void testGetDatasourceListWithNullPrefix() {
        String prefix = null;
        ValueCompletion valueCompletion = this.getValueCompletionComplete(prefix);
        JNDICompleterTestCase.assertNotNull((Object)valueCompletion);
        JNDICompleterTestCase.assertTrue((String)"valueCompletion must be empty because no datasources is available", (boolean)valueCompletion.isEmpty());
    }

    public void testGetDatasourceListWithEmptyPrefix() {
        String prefix = "";
        ValueCompletion valueCompletion = this.getValueCompletionComplete(prefix);
        JNDICompleterTestCase.assertNotNull((Object)valueCompletion);
        JNDICompleterTestCase.assertTrue((String)"valueCompletion must be empty because no datasources is available", (boolean)valueCompletion.isEmpty());
    }

    public void testGetJndiPathWithNullArgs() {
        try {
            JNDICompleterTestCase.assertNull((Object)this.completer.getJndiPath(null, "toto", null));
            JNDICompleterTestCase.fail((String)"An exception should be throw because of null contextName");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            JNDICompleterTestCase.assertNull((Object)this.completer.getJndiPath("toto", null, null));
            JNDICompleterTestCase.fail((String)"An exception should be throw because of null contextName");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            JNDICompleterTestCase.assertNull((Object)this.completer.getJndiPath("toto", "t", null));
            JNDICompleterTestCase.fail((String)"An exception should be throw because of null contextName");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testgetJndiWithValue() {
        JNDICompleterTestCase.assertNull((Object)this.completer.getJndiPath("java:jboss/", "datasources", "jdbc"));
        JNDICompleterTestCase.assertNotNull((Object)this.completer.getJndiPath("java:jboss/", "datasources", "java"));
    }

    public void testGetJndiPathWithEmptyPrefix() {
        JNDICompleterTestCase.assertEquals((String)"java:jboss/datasources", (String)this.completer.getJndiPath("java:jboss/", "datasources", ""));
        JNDICompleterTestCase.assertEquals((String)"java:jboss/datasources", (String)this.completer.getJndiPath("java:jboss", "/datasources", ""));
    }

    public void testGetJndiPathWithPrefixltSuffix() {
        JNDICompleterTestCase.assertEquals((String)"va:jboss/datasources", (String)this.completer.getJndiPath("java:jboss/", "datasources", "ja"));
        JNDICompleterTestCase.assertEquals((String)"ava:jboss/datasources", (String)this.completer.getJndiPath("java:jboss/", "datasources", "j"));
        JNDICompleterTestCase.assertEquals((String)"java:jboss/datasources", (String)this.completer.getJndiPath("java:jboss/", "datasources", ""));
        JNDICompleterTestCase.assertEquals(null, (String)this.completer.getJndiPath("java:jboss/", "TransactionManager", "java:ja"));
    }

    public void testGetJndiPathWithPrefixgtSuffix() {
        JNDICompleterTestCase.assertEquals((String)"atasources", (String)this.completer.getJndiPath("java:jboss/", "datasources", "java:jboss/d"));
        JNDICompleterTestCase.assertEquals(null, (String)this.completer.getJndiPath("java:jboss/", "datasources", "java:jboss/datasources"));
        JNDICompleterTestCase.assertEquals(null, (String)this.completer.getJndiPath("java:jboss/", "datasources", "java:jboss/datasourcesAAA"));
        JNDICompleterTestCase.assertEquals(null, (String)this.completer.getJndiPath("java:jboss/", "TransactionManager", "java:jboss/datasources"));
    }
}

