/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.sshd;

import org.apache.sshd.SshServer;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.KeyPairProvider;
import org.apache.sshd.common.Session;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.keyprovider.PEMGeneratorHostKeyProvider;
import org.crsh.shell.ShellContext;
import org.crsh.term.CRaSHLifeCycle;
import org.crsh.term.sshd.CRaSHCommandFactory;
import org.crsh.term.sshd.scp.SCPCommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHLifeCycle
extends CRaSHLifeCycle {
    public static final Session.AttributeKey<String> USERNAME = new Session.AttributeKey();
    public static final Session.AttributeKey<String> PASSWORD = new Session.AttributeKey();
    private final Logger log = LoggerFactory.getLogger(SSHLifeCycle.class);
    private SshServer server;
    private int port;
    private String keyPath;

    public SSHLifeCycle(ShellContext context) {
        super(context);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getKeyPath() {
        return this.keyPath;
    }

    public void setKeyPath(String keyPath) {
        this.keyPath = keyPath;
    }

    protected void doInit() {
        try {
            SshServer server = SshServer.setUpDefaultServer();
            server.setPort(this.port);
            server.setShellFactory((Factory)new CRaSHCommandFactory(this.getShellFactory(), this.getExecutor()));
            server.setCommandFactory((CommandFactory)new SCPCommandFactory());
            server.setKeyPairProvider((KeyPairProvider)new PEMGeneratorHostKeyProvider(this.keyPath));
            server.setPasswordAuthenticator((PasswordAuthenticator)new /* Unavailable Anonymous Inner Class!! */);
            this.log.info("About to start CRaSSHD");
            server.start();
            this.log.info("CRaSSHD started on port " + this.port);
            this.server = server;
        }
        catch (Throwable e) {
            this.log.error("Could not start CRaSSHD", e);
        }
    }

    protected void doDestroy() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (InterruptedException e) {
                this.log.debug("Got an interruption when stopping server", (Throwable)e);
            }
        }
    }
}

