/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.crsh.servlet.ServletShellContext;
import org.crsh.term.sshd.SSHLifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHServletLifeCycle
implements ServletContextListener {
    private final Logger log = LoggerFactory.getLogger(SSHServletLifeCycle.class);
    private SSHLifeCycle lifeCycle;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        int port = Integer.parseInt(sc.getInitParameter("ssh.port").trim());
        String keyPath = sc.getInitParameter("ssh.keypath");
        if (keyPath == null) {
            this.log.debug("No key path found in web.xml will use the default one");
            keyPath = sc.getRealPath("/WEB-INF/sshd/hostkey.pem");
            this.log.debug("Going to use the key path at " + keyPath);
        }
        SSHLifeCycle lifeCycle = new SSHLifeCycle(new ServletShellContext(sc, Thread.currentThread().getContextClassLoader()));
        lifeCycle.setKeyPath(keyPath);
        lifeCycle.setPort(port);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.lifeCycle != null) {
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

