/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import java.util.Collections;
import org.crsh.command.ScriptException;
import org.crsh.shell.ErrorType;

public abstract class ShellResponse {
    public abstract String getText();

    public static class Error
    extends ShellResponse {
        private final ErrorType type;
        private final Throwable throwable;

        public Error(ErrorType type, Throwable throwable) {
            this.type = type;
            this.throwable = throwable;
        }

        public ErrorType getType() {
            return this.type;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public String getText() {
            String result;
            if (this.throwable instanceof java.lang.Error) {
                throw (java.lang.Error)this.throwable;
            }
            if (this.throwable instanceof ScriptException) {
                result = "Error: " + this.throwable.getMessage();
            } else if (this.throwable instanceof RuntimeException) {
                result = "Unexpected exception: " + this.throwable.getMessage();
                this.throwable.printStackTrace(System.err);
            } else if (this.throwable instanceof Exception) {
                result = "Unexpected exception: " + this.throwable.getMessage();
                this.throwable.printStackTrace(System.err);
            } else {
                result = "Unexpected throwable: " + this.throwable.getMessage();
                this.throwable.printStackTrace(System.err);
            }
            return result;
        }

        public String toString() {
            return "ShellResponse.Error[type=" + (Object)((Object)this.type) + ",throwable=" + this.throwable.getMessage() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Display
    extends Ok {
        private final String text;

        public Display(String text) {
            this.text = text;
        }

        public Display(Iterable<?> produced, String text) {
            super(produced);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ok
    extends ShellResponse {
        private final Iterable<?> produced;

        public Ok() {
            this(Collections.emptyList());
        }

        public Ok(Iterable<?> produced) {
            this.produced = produced;
        }

        public Iterable<?> getProduced() {
            return this.produced;
        }

        @Override
        public String getText() {
            return "";
        }
    }

    public static class Close
    extends ShellResponse {
        public String getText() {
            return "Have a good day!\r\n";
        }
    }

    public static class NoCommand
    extends ShellResponse {
        public String getText() {
            return "Please type something";
        }
    }

    public static class UnkownCommand
    extends ShellResponse {
        private final String name;

        public UnkownCommand(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return "Unknown command " + this.name;
        }
    }

    public static class SyntaxError
    extends ShellResponse {
        public String getText() {
            return "Syntax error";
        }
    }
}

