/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.command.ShellCommand;
import org.crsh.jcr.NodeMetaClass;
import org.crsh.shell.ErrorType;
import org.crsh.shell.Resource;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.impl.AST;
import org.crsh.shell.impl.GroovyScriptCommand;
import org.crsh.shell.impl.Parser;
import org.crsh.util.TimestampedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRaSH
implements Shell {
    private static final Logger log;
    private final GroovyShell groovyShell;
    private final ShellContext context;
    private final Map<String, TimestampedObject<Class<ShellCommand>>> commands;
    final Map<String, Object> attributes;

    ShellCommand getCommand(String name) {
        TimestampedObject closure = this.commands.get(name);
        String id = "/groovy/commands/" + name + ".groovy";
        Resource script = this.context.loadResource(id);
        if (script != null) {
            if (closure != null && script.getTimestamp() != closure.getTimestamp()) {
                closure = null;
            }
            if (closure == null) {
                Class clazz = this.groovyShell.getClassLoader().parseClass(script.getContent(), id);
                if (ShellCommand.class.isAssignableFrom(clazz)) {
                    Class commandClazz = clazz;
                    closure = this.biltooo(script.getTimestamp(), commandClazz);
                    this.commands.put(name, closure);
                } else {
                    log.error("Parsed script does not implements " + ShellCommand.class.getName());
                }
            }
        }
        if (closure == null) {
            return null;
        }
        try {
            return closure.getObject().newInstance();
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private <T extends ShellCommand> TimestampedObject<Class<T>> biltooo(long timestamp, Class<T> aaa) {
        return new TimestampedObject<Class<T>>(timestamp, aaa);
    }

    public GroovyShell getGroovyShell() {
        return this.groovyShell;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public CRaSH(ShellContext context) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("version", context.getVersion());
        CompilerConfiguration config = new CompilerConfiguration();
        config.setRecompileGroovySource(true);
        config.setScriptBaseClass(GroovyScriptCommand.class.getName());
        GroovyShell groovyShell = new GroovyShell(context.getLoader(), new Binding(attributes), config);
        String script = context.loadResource("/groovy/login.groovy").getContent();
        groovyShell.evaluate(script, "/groovy/login.groovy");
        this.attributes = attributes;
        this.groovyShell = groovyShell;
        this.commands = new ConcurrentHashMap<String, TimestampedObject<Class<ShellCommand>>>();
        this.context = context;
    }

    public void close() {
        String script = this.context.loadResource("/groovy/logout.groovy").getContent();
        this.groovyShell.evaluate(script, "/groovy/logout.groovy");
    }

    public ShellResponse evaluate(String request) {
        return this.evaluate(request, null);
    }

    @Override
    public String getWelcome() {
        return this.groovyShell.evaluate("welcome();").toString();
    }

    @Override
    public String getPrompt() {
        return (String)this.groovyShell.evaluate("prompt();");
    }

    @Override
    public ShellResponse evaluate(String request, ShellResponseContext responseContext) {
        log.debug("Invoking request " + request);
        Parser parser = new Parser(request);
        AST ast = parser.parse();
        if (ast instanceof AST.Expr) {
            AST.Expr expr = (AST.Expr)ast;
            try {
                ShellResponse.UnkownCommand resp = expr.createCommands(this);
                if (resp != null) {
                    return resp;
                }
            }
            catch (Exception e) {
                return new ShellResponse.Error(ErrorType.EVALUATION, e);
            }
            return expr.execute(responseContext, this.attributes);
        }
        return new ShellResponse.NoCommand();
    }

    static {
        NodeMetaClass.setup();
        log = LoggerFactory.getLogger(CRaSH.class);
    }
}

