/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.sshd;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.apache.sshd.common.PtyMode;
import org.apache.sshd.server.Environment;
import org.crsh.shell.connector.Connector;
import org.crsh.shell.impl.CRaSH;
import org.crsh.term.BaseTerm;
import org.crsh.term.TermShellAdapter;
import org.crsh.term.sshd.AbstractCommand;
import org.crsh.term.sshd.CRaSHCommandFactory;
import org.crsh.term.sshd.SSHContext;
import org.crsh.term.sshd.SSHIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRaSHCommand
extends AbstractCommand
implements Runnable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CRaSHCommandFactory factory;
    private Thread thread;
    private SSHContext context;
    private Connector connector;
    private CRaSH shell;

    public CRaSHCommand(CRaSHCommandFactory factory) {
        this.factory = factory;
    }

    public void start(Environment env) throws IOException {
        this.context = new SSHContext((Integer)env.getPtyModes().get(PtyMode.VERASE));
        this.shell = this.factory.builder.build();
        this.connector = new Connector(this.factory.executor, this.shell);
        this.thread = new Thread((Runnable)this, "CRaSH");
        this.thread.start();
    }

    public void destroy() {
        this.connector.close();
        this.shell.close();
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(this.out);
            InputStreamReader reader = new InputStreamReader(this.in);
            SSHIO io = new SSHIO(reader, writer, this.context.verase);
            BaseTerm term = new BaseTerm(io, new TermShellAdapter(this.connector));
            term.run();
        }
        finally {
            this.callback.onExit(0);
        }
    }
}

