/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl;

import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.crsh.command.CommandContext;
import org.crsh.command.ShellPrinter;
import org.crsh.shell.ShellResponseContext;
import org.crsh.shell.io.ShellWriter;
import org.crsh.util.LineFeedWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CommandContextImpl<C, P>
implements CommandContext<C, P> {
    private final ShellResponseContext responseContext;
    private final Map<String, Object> attributes;
    private ShellPrinter writer;
    private StringWriter buffer;
    private List<P> products;
    private Iterable<C> consumedItems;

    public CommandContextImpl(ShellResponseContext responseContext, Iterable<C> consumedItems, Map<String, Object> attributes) {
        this.attributes = attributes;
        this.responseContext = responseContext;
        this.writer = null;
        this.buffer = null;
        this.consumedItems = consumedItems;
        this.products = Collections.emptyList();
    }

    public List<P> getProducedItems() {
        return this.products;
    }

    public StringWriter getBuffer() {
        return this.buffer;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public boolean isPiped() {
        return this.consumedItems != null;
    }

    public Iterable<C> consume() {
        if (this.consumedItems == null) {
            throw new IllegalStateException("Cannot consume as no pipe operation is involved");
        }
        return this.consumedItems;
    }

    public void produce(P product) {
        if (this.products.isEmpty()) {
            this.products = new LinkedList();
        }
        this.products.add(product);
    }

    public ShellPrinter getWriter() {
        if (this.writer == null) {
            this.buffer = new StringWriter();
            this.writer = new ShellPrinter((ShellWriter)new LineFeedWriter((Appendable)this.buffer, "\r\n"));
        }
        return this.writer;
    }

    public String readLine(String msg, boolean echo) {
        if (this.responseContext != null) {
            return this.responseContext.readLine(msg, echo);
        }
        throw new IllegalStateException("The command does not have access to console line reading");
    }
}

