/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import org.crsh.shell.Resource;
import org.crsh.shell.ResourceKind;
import org.crsh.shell.ShellContext;
import org.crsh.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletShellContext
implements ShellContext {
    private final ServletContext servletContext;
    private final ClassLoader loader;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String version;
    private ScheduledExecutorService executor;
    private volatile List<String> dirs;

    public ServletShellContext(ServletContext servletContext, ClassLoader loader) {
        if (servletContext == null) {
            throw new NullPointerException();
        }
        if (loader == null) {
            throw new NullPointerException();
        }
        String version = null;
        try {
            Properties props = new Properties();
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("META-INF/maven/org.crsh/crsh.core/pom.properties");
            if (in != null) {
                props.load(in);
                version = props.getProperty("version");
            }
        }
        catch (Exception e) {
            this.log.error("Could not load maven properties", (Throwable)e);
        }
        if (version == null) {
            this.log.warn("No version found will use unknown value instead");
            version = "unknown";
        }
        this.servletContext = servletContext;
        this.loader = loader;
        this.version = version;
        this.dirs = Collections.emptyList();
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public String getVersion() {
        return this.version;
    }

    public Resource loadResource(String resourceId, ResourceKind resourceKind) {
        Resource res = null;
        try {
            URL url = null;
            switch (resourceKind) {
                case LIFECYCLE: {
                    if ("login".equals(resourceId)) {
                        url = this.servletContext.getResource("/WEB-INF/groovy/login.groovy");
                        break;
                    }
                    if (!"logout".equals(resourceId)) break;
                    url = this.servletContext.getResource("/WEB-INF/groovy/logout.groovy");
                    break;
                }
                case SCRIPT: {
                    String path;
                    Iterator<String> i$ = this.dirs.iterator();
                    while (i$.hasNext() && (url = this.servletContext.getResource((path = i$.next()) + resourceId + ".groovy")) == null) {
                    }
                    break;
                }
                case CONFIG: {
                    if (!"telnet.properties".equals(resourceId)) break;
                    url = this.servletContext.getResource("/WEB-INF/telnet/telnet.properties");
                }
            }
            if (url != null) {
                URLConnection conn = url.openConnection();
                long timestamp = conn.getLastModified();
                InputStream in = url.openStream();
                String content = IO.readAsUTF8(in);
                res = new Resource(content, timestamp);
            }
        }
        catch (IOException e) {
            this.log.warn("Could not obtain resource " + resourceId, (Throwable)e);
        }
        return res;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public synchronized void start() {
        if (this.executor == null) {
            this.executor = new ScheduledThreadPoolExecutor(1);
            this.executor.scheduleWithFixedDelay(new Runnable(){
                int count = 0;

                public void run() {
                    Set set = ServletShellContext.this.servletContext.getResourcePaths("/WEB-INF/groovy/commands/");
                    if (set != null) {
                        ArrayList<String> newDirs = new ArrayList<String>();
                        newDirs.add("/WEB-INF/groovy/commands/");
                        for (String path : set) {
                            if (!path.endsWith("/")) continue;
                            newDirs.add(path);
                        }
                        ServletShellContext.this.dirs = newDirs;
                    }
                }
            }, 0L, 1L, TimeUnit.SECONDS);
        } else {
            this.log.warn("Attempt to double start");
        }
    }

    public synchronized void stop() {
        if (this.executor != null) {
            ScheduledExecutorService tmp = this.executor;
            this.executor = null;
            tmp.shutdown();
        } else {
            this.log.warn("Attempt to stop when stopped");
        }
    }
}

