/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.sshd.scp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Session;
import org.crsh.fs.FileSystem;
import org.crsh.term.sshd.scp.SCPCommand;
import org.crsh.util.BytesOutputStream;
import org.crsh.util.IO;

public class SourceCommand
extends SCPCommand
implements Runnable {
    private boolean recursive;

    public SourceCommand(String target, boolean recursive) {
        super(target);
        this.recursive = recursive;
    }

    protected void execute(Session session, String path) throws Exception {
        FileSystem fs = new FileSystem(){

            public void startDirectory(String directoryName) throws IOException {
                SourceCommand.this.out.write("D0755 0 ".getBytes());
                SourceCommand.this.out.write(directoryName.getBytes());
                SourceCommand.this.out.write("\n".getBytes());
                SourceCommand.this.out.flush();
                SourceCommand.this.readAck();
            }

            public void file(String fileName, int length, InputStream data) throws IOException {
                SourceCommand.this.out.write("C0644 ".getBytes());
                SourceCommand.this.out.write(Integer.toString(length).getBytes());
                SourceCommand.this.out.write(" ".getBytes());
                SourceCommand.this.out.write(fileName.getBytes());
                SourceCommand.this.out.write("\n".getBytes());
                SourceCommand.this.out.flush();
                SourceCommand.this.readAck();
                IO.copy(data, SourceCommand.this.out);
                SourceCommand.this.ack();
                SourceCommand.this.readAck();
            }

            public void endDirectory(String directoryName) throws IOException {
                SourceCommand.this.out.write("E\n".getBytes());
                SourceCommand.this.out.flush();
                SourceCommand.this.readAck();
            }
        };
        Item item = session.getItem(path);
        if (!(item instanceof Node)) {
            throw new Exception("Cannot export a property");
        }
        BytesOutputStream baos = new BytesOutputStream();
        session.exportSystemView(path, (OutputStream)baos, false, false);
        String name = item.getName();
        name = name.length() == 0 ? "jcr_root.xml" : name.replace(":", "_") + ".xml";
        baos.flush();
        baos.close();
        fs.file(name, baos.size(), baos.getInputStream());
    }
}

