/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.crsh.connector.sshd.SSHLifeCycle;
import org.crsh.servlet.ServletShellContext;
import org.crsh.shell.ShellContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHServletLifeCycle
implements ServletContextListener {
    private final Logger log = LoggerFactory.getLogger(SSHServletLifeCycle.class);
    private SSHLifeCycle lifeCycle;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        String username = sc.getInitParameter("ssh.username").trim();
        String password = sc.getInitParameter("ssh.password").trim();
        int port = Integer.parseInt(sc.getInitParameter("ssh.port").trim());
        String keyPath = sc.getInitParameter("ssh.keypath");
        if (keyPath == null) {
            this.log.debug("No key path found in web.xml will use the default one");
            keyPath = sc.getRealPath("/WEB-INF/sshd/hostkey.pem");
            this.log.debug("Going to use the key path at " + keyPath);
        }
        SSHLifeCycle lifeCycle = new SSHLifeCycle((ShellContext)new ServletShellContext(sc, Thread.currentThread().getContextClassLoader()));
        lifeCycle.setKeyPath(keyPath);
        lifeCycle.setPort(port);
        lifeCycle.setUserName(username);
        lifeCycle.setPassword(password);
        lifeCycle.init();
        this.lifeCycle = lifeCycle;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.lifeCycle != null) {
            this.lifeCycle.destroy();
            this.lifeCycle = null;
        }
    }
}

