/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.connector.sshd.scp;

import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.crsh.connector.sshd.FailCommand;
import org.crsh.connector.sshd.scp.SCPAction;
import org.crsh.connector.sshd.scp.SinkCommand;
import org.crsh.connector.sshd.scp.SourceCommand;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCPCommandFactory
implements CommandFactory {
    private static final Logger log = LoggerFactory.getLogger(SCPCommandFactory.class);

    public Command createCommand(String command) {
        command = command.trim();
        log.debug("About to execute shell command " + command);
        if (command.startsWith("scp ")) {
            try {
                command = command.substring(4);
                SCPAction action = new SCPAction();
                CmdLineParser parser = new CmdLineParser((Object)action);
                parser.parseArgument(command.split("(\\s)+"));
                if (Boolean.TRUE.equals(action.isSource())) {
                    return new SourceCommand(action.getArgument(), Boolean.TRUE.equals(action.isRecursive()));
                }
                if (Boolean.TRUE.equals(action.isSink())) {
                    return new SinkCommand(action.getArgument(), Boolean.TRUE.equals(action.isRecursive()));
                }
                return new FailCommand("No handle that kind of action for now " + action);
            }
            catch (CmdLineException e) {
                e.printStackTrace();
                return null;
            }
        }
        return new FailCommand("No other command than scp can be executed " + command);
    }
}

