/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.connector.telnet;

import java.io.IOException;
import net.wimpi.telnetd.io.BasicTerminalIO;
import net.wimpi.telnetd.net.Connection;
import org.crsh.connector.ShellConnector;
import org.crsh.connector.telnet.TelnetLifeCycle;
import org.crsh.util.CompletionHandler;
import org.crsh.util.Input;
import org.crsh.util.InputDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelnetDecoder
extends InputDecoder {
    private final Logger log = LoggerFactory.getLogger(TelnetDecoder.class);
    private final Connection conn;
    private final ShellConnector connector;
    private final BasicTerminalIO termIO;

    public TelnetDecoder(Connection connection) {
        this.conn = connection;
        this.connector = new ShellConnector(TelnetLifeCycle.instance.getShellBuilder());
        this.termIO = connection.getTerminalIO();
    }

    public void run() throws IOException {
        String welcome = this.connector.open();
        this.writeFully(welcome);
        while (!this.isClosed()) {
            int code = this.termIO.read();
            this.append(code);
        }
    }

    public boolean isClosed() {
        return this.connector.isClosed();
    }

    public void close() {
        try {
            this.termIO.flush();
            this.conn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.connector.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void append(int i) throws IOException {
        Input input;
        if (i == 1302) {
            this.appendDel();
        } else if (i == 10) {
            this.appendData('\r');
            this.appendData('\n');
        } else if (i >= 0 && i < 128) {
            if (i == 3) {
                this.log.debug("Want to cancel evaluation");
                if (this.connector.cancelEvalutation()) {
                    this.log.debug("Evaluation cancelled");
                }
                String s = "\r\n" + this.connector.getPrompt();
                this.writeFully(s);
            } else {
                this.appendData((char)i);
            }
        }
        if (this.hasNext() && (input = this.next()) instanceof Input.Chars) {
            String line = ((Input.Chars)input).getValue();
            this.log.debug("Submitting command " + line);
            this.connector.submitEvaluation(line, (CompletionHandler)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void writeFully(String prompt) throws IOException {
        this.termIO.write(prompt);
        this.termIO.flush();
    }

    protected void echoDel() throws IOException {
        this.termIO.moveLeft(1);
        this.termIO.write(' ');
        this.termIO.moveLeft(1);
        this.termIO.flush();
    }

    protected void echo(String s) throws IOException {
        this.writeFully(s);
    }

    protected void echo(char c) throws IOException {
        this.termIO.write(c);
        this.termIO.flush();
    }

    static /* synthetic */ Logger access$000(TelnetDecoder x0) {
        return x0.log;
    }

    static /* synthetic */ void access$100(TelnetDecoder x0, String x1) throws IOException {
        x0.writeFully(x1);
    }
}

