/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.io.StringWriter;
import java.io.Writer;
import org.crsh.shell.CommandContext;
import org.crsh.shell.Description;
import org.crsh.shell.ScriptException;
import org.crsh.shell.ShellCommand;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public abstract class ClassCommand
extends GroovyObjectSupport
implements ShellCommand {
    private CommandContext context;

    public Object invokeMethod(String name, Object args) {
        try {
            return super.invokeMethod(name, args);
        }
        catch (MissingMethodException e) {
            Object o = this.context.get((Object)name);
            if (o instanceof Closure) {
                Closure closure = (Closure)o;
                if (args instanceof Object[]) {
                    Object[] array = (Object[])args;
                    if (array.length == 0) {
                        return closure.call();
                    }
                    return closure.call(array);
                }
                return closure.call(args);
            }
            throw e;
        }
    }

    public Object getProperty(String property) {
        try {
            return super.getProperty(property);
        }
        catch (MissingPropertyException e) {
            return this.context.get((Object)property);
        }
    }

    public void setProperty(String property, Object newValue) {
        try {
            super.setProperty(property, newValue);
        }
        catch (MissingPropertyException e) {
            this.context.put((Object)property, newValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(CommandContext context, String ... args) throws ScriptException {
        Object res;
        if (context == null) {
            throw new NullPointerException();
        }
        if (args == null) {
            throw new NullPointerException();
        }
        CmdLineParser parser = new CmdLineParser((Object)this);
        if (args.length > 0 && ("-h".equals(args[0]) || "--help".equals(args[0]))) {
            StringWriter out = new StringWriter();
            Description description = this.getClass().getAnnotation(Description.class);
            if (description != null) {
                out.write(description.value());
                out.write("\n");
            }
            parser.printUsage((Writer)out, null);
            return out;
        }
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            throw new ScriptException(e.getMessage(), (Throwable)e);
        }
        try {
            this.context = context;
            res = this.execute();
        }
        finally {
            this.context = null;
        }
        return res;
    }

    protected abstract Object execute() throws ScriptException;

    private void generateHelp() {
    }
}

