/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.crsh.jcr.NodeMetaClass;
import org.crsh.shell.CommandContext;
import org.crsh.shell.Evaluable;
import org.crsh.shell.Resource;
import org.crsh.shell.ScriptCommand;
import org.crsh.shell.ShellCommand;
import org.crsh.shell.ShellContext;
import org.crsh.shell.ShellResponse;
import org.crsh.util.CompletionHandler;
import org.crsh.util.ImmediateFuture;
import org.crsh.util.TimestampedObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shell {
    private static final Logger log;
    private final GroovyShell groovyShell;
    private final StringBuffer out;
    private final ShellContext context;
    private final Map<String, TimestampedObject<Class<ShellCommand>>> commands;
    final CommandContext commandContext;
    private final ExecutorService executor;

    ShellCommand getClosure(String name) {
        TimestampedObject closure = (TimestampedObject)this.commands.get(name);
        String id = "/groovy/commands/" + name + ".groovy";
        Resource script = this.context.loadResource(id);
        if (script != null) {
            if (closure != null && script.getTimestamp() != closure.getTimestamp()) {
                closure = null;
            }
            if (closure == null) {
                Class clazz = this.groovyShell.getClassLoader().parseClass(script.getContent(), id);
                if (ShellCommand.class.isAssignableFrom(clazz)) {
                    Class commandClazz = clazz;
                    closure = this.biltooo(script.getTimestamp(), commandClazz);
                    this.commands.put(name, closure);
                } else {
                    log.error("Parsed script does not implements " + ShellCommand.class.getName());
                }
            }
        }
        try {
            return (ShellCommand)((Class)closure.getObject()).newInstance();
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }

    private <T extends ShellCommand> TimestampedObject<Class<T>> biltooo(long timestamp, Class<T> aaa) {
        return new TimestampedObject(timestamp, aaa);
    }

    public GroovyShell getGroovyShell() {
        return this.groovyShell;
    }

    public Object getAttribute(String name) {
        return this.commandContext.get((Object)name);
    }

    public void setAttribute(String name, Object value) {
        this.commandContext.put((Object)name, value);
    }

    public Shell(ShellContext context) {
        this(context, null);
    }

    Shell(ShellContext context, ExecutorService executor) {
        CommandContext commandContext = new CommandContext();
        CompilerConfiguration config = new CompilerConfiguration();
        config.setRecompileGroovySource(true);
        config.setScriptBaseClass(ScriptCommand.class.getName());
        GroovyShell groovyShell = new GroovyShell(context.getLoader(), new Binding((Map)commandContext), config);
        String script = context.loadResource("/groovy/login.groovy").getContent();
        groovyShell.evaluate(script, "/groovy/login.groovy");
        this.commandContext = commandContext;
        this.out = new StringBuffer();
        this.groovyShell = groovyShell;
        this.commands = new ConcurrentHashMap();
        this.context = context;
        this.executor = executor;
    }

    public String getPrompt() {
        return (String)this.groovyShell.evaluate("prompt();");
    }

    public void close() {
        String script = this.context.loadResource("/groovy/logout.groovy").getContent();
        this.groovyShell.evaluate(script, "/groovy/logout.groovy");
    }

    public ShellResponse evaluate(String s) {
        Evaluable evaluable = new Evaluable(this, s, null);
        return evaluable.call();
    }

    public Future<ShellResponse> submitEvaluation(String s, CompletionHandler<ShellResponse> handler) {
        Evaluable callable = new Evaluable(this, s, handler);
        if (this.executor != null) {
            log.debug("Submitting to executor");
            return this.executor.submit(callable);
        }
        ShellResponse response = callable.call();
        return new ImmediateFuture((Object)response);
    }

    static {
        NodeMetaClass.setup();
        log = LoggerFactory.getLogger(Shell.class);
    }
}

