/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.util;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.crsh.util.Input;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class InputDecoder
implements Iterator<Input> {
    private char[] buffer = new char[128];
    private int size = 0;
    private LinkedList<Input> lines = new LinkedList();
    private int previous = -1;

    protected abstract void echo(char var1) throws IOException;

    protected abstract void echo(String var1) throws IOException;

    protected abstract void echoDel() throws IOException;

    public void appendData(char c) throws IOException {
        if (c == '\n' && this.previous == 13 || c == '\r' && this.previous == 10) {
            this.previous = -1;
        } else if (c == '\n' || c == '\r') {
            String line = new String(this.buffer, 0, this.size);
            this.lines.add(new Input.Chars(line));
            this.previous = c;
            this.size = 0;
            this.echo("\r\n");
        } else {
            this.push(c);
            this.previous = c;
            this.echo(c);
        }
    }

    public void appendDel() throws IOException {
        this.pop();
        this.previous = this.size > 0 ? this.buffer[this.size] : -1;
        this.echoDel();
    }

    public int getSize() {
        return this.size;
    }

    private void pop() {
        if (this.size > 0) {
            --this.size;
        }
    }

    @Override
    public boolean hasNext() {
        return this.lines.size() > 0;
    }

    @Override
    public Input next() {
        if (this.lines.size() > 0) {
            return (Input)this.lines.removeFirst();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void push(char c) {
        if (this.size >= this.buffer.length) {
            char[] tmp = new char[this.buffer.length * 2 + 1];
            System.arraycopy(this.buffer, 0, tmp, 0, this.buffer.length);
            this.buffer = tmp;
        }
        this.buffer[this.size++] = c;
    }
}

