/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.ServletContext;
import org.crsh.shell.Resource;
import org.crsh.shell.ShellContext;
import org.crsh.util.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletShellContext
implements ShellContext {
    private final ServletContext servletContext;
    private final ClassLoader loader;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public ServletShellContext(ServletContext servletContext, ClassLoader loader) {
        if (servletContext == null) {
            throw new NullPointerException();
        }
        if (loader == null) {
            throw new NullPointerException();
        }
        this.servletContext = servletContext;
        this.loader = loader;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Resource loadResource(String resourceId) {
        try {
            URL url = this.servletContext.getResource("/WEB-INF/" + resourceId);
            URLConnection conn = url.openConnection();
            long timestamp = conn.getLastModified();
            InputStream in = url.openStream();
            String content = IO.readAsUTF8((InputStream)in);
            return new Resource(content, timestamp);
        }
        catch (IOException e) {
            this.log.warn("Could not find resource " + resourceId, (Throwable)e);
            return null;
        }
    }

    public ClassLoader getLoader() {
        return this.loader;
    }
}

