/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.connector;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.crsh.Info;
import org.crsh.shell.Shell;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.connector.Connector;
import org.crsh.shell.connector.ConnectorResponseContext;
import org.crsh.shell.connector.ConnectorStatus;
import org.crsh.shell.connector.FutureEvaluation;
import org.crsh.shell.connector.ResponseEvaluation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connector {
    private final Logger log = LoggerFactory.getLogger(Connector.class);
    private ConnectorStatus status;
    private FutureEvaluation futureEvaluation;
    private final Object lock;
    private final Shell shell;
    private final ExecutorService executor;

    public Connector(Shell shell) {
        this(null, shell);
    }

    public Connector(ExecutorService executor, Shell shell) {
        this.executor = executor;
        this.shell = shell;
        this.status = ConnectorStatus.INITIAL;
        this.lock = new Object();
    }

    public boolean isClosed() {
        return this.status == ConnectorStatus.CLOSED;
    }

    public String open() {
        String hostName;
        if (this.status != ConnectorStatus.INITIAL) {
            throw new IllegalStateException();
        }
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        String ret = "CRaSH " + Info.getVersion() + " (http://crsh.googlecode.com)\r\n" + "Welcome to " + hostName + "!\r\n" + "It is " + new Date() + " now.\r\n" + this.shell.getPrompt();
        this.status = ConnectorStatus.AVAILABLE;
        return ret;
    }

    public String getPrompt() {
        return this.shell.getPrompt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorStatus getStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    public Future<ShellResponse> submitEvaluation(String request) {
        return this.submitEvaluation(request, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<ShellResponse> submitEvaluation(String request, ConnectorResponseContext handler) {
        1 responseContext = new /* Unavailable Anonymous Inner Class!! */;
        Object object = this.lock;
        synchronized (object) {
            Future<ShellResponse> clientResponse;
            if (this.status != ConnectorStatus.AVAILABLE) {
                throw new IllegalStateException("State was " + this.status);
            }
            Object callable = "bye".equals(request) ? new /* Unavailable Anonymous Inner Class!! */ : new /* Unavailable Anonymous Inner Class!! */;
            ResponseEvaluation evaluation = new ResponseEvaluation(this, handler, (Callable)callable);
            if (this.executor != null) {
                Future<ShellResponse> futureResponse = this.executor.submit(evaluation);
                this.futureEvaluation = new FutureEvaluation(futureResponse, handler);
                this.status = ConnectorStatus.EVALUATING;
                clientResponse = futureResponse;
            } else {
                try {
                    FutureTask futureResponse = new FutureTask(evaluation);
                    this.futureEvaluation = new FutureEvaluation(futureResponse, handler);
                    this.status = ConnectorStatus.EVALUATING;
                    futureResponse.run();
                    clientResponse = futureResponse;
                }
                catch (Exception e) {
                    AssertionError afe = new AssertionError((Object)"Should not happen");
                    ((Throwable)((Object)afe)).initCause(e);
                    throw afe;
                }
            }
            return clientResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelEvalutation() {
        FutureEvaluation evaluation = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.status == ConnectorStatus.EVALUATING) {
                evaluation = this.futureEvaluation;
                this.status = ConnectorStatus.AVAILABLE;
                this.futureEvaluation = null;
            }
        }
        if (evaluation != null) {
            evaluation.futureResponse.cancel(true);
            if (evaluation.responseHandler != null) {
                evaluation.responseHandler.done(false);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(ConnectorResponseContext responseContext, ShellResponse response) {
        Object object = this.lock;
        synchronized (object) {
            String ret = null;
            switch (4.$SwitchMap$org$crsh$shell$connector$ConnectorStatus[this.status.ordinal()]) {
                case 1: {
                    try {
                        ret = response.getText();
                        this.futureEvaluation = null;
                        break;
                    }
                    finally {
                        this.status = ConnectorStatus.AVAILABLE;
                    }
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"That should not be possible");
                }
            }
            if (responseContext != null) {
                if (ret != null) {
                    this.log.debug("Making handler response callback with " + ret);
                    responseContext.completed(ret);
                }
                responseContext.setPrompt(this.shell.getPrompt());
                this.log.debug("Signaling done to response context");
                responseContext.done(response instanceof ShellResponse.Close);
            }
        }
    }

    public String popResponse() {
        ShellResponse response = null;
        if (this.futureEvaluation != null) {
            try {
                response = (ShellResponse)this.futureEvaluation.futureResponse.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (response != null) {
            return response.getText();
        }
        return null;
    }

    public String evaluate(String request) {
        this.submitEvaluation(request, null);
        return this.popResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            switch (4.$SwitchMap$org$crsh$shell$connector$ConnectorStatus[this.status.ordinal()]) {
                case 2: 
                case 4: {
                    break;
                }
                case 1: {
                    throw new UnsupportedOperationException("todo :-)");
                }
            }
            this.status = ConnectorStatus.CLOSED;
        }
    }

    static /* synthetic */ Shell access$000(Connector x0) {
        return x0.shell;
    }
}

