/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.sshd.scp;

import java.io.IOException;
import org.crsh.fs.FileSystem;
import org.crsh.term.sshd.scp.FileSystemAction;
import org.crsh.term.sshd.scp.SCPCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
abstract class FileSystemAction {
    private static final Logger log = LoggerFactory.getLogger(FileSystemAction.class);

    FileSystemAction() {
    }

    public static void read(SCPCommand cmd, FileSystem fs) throws IOException {
        cmd.ack();
        log.debug("Want to read line");
        String line = cmd.readLine();
        log.debug("Read line " + line);
        FileSystemAction action = FileSystemAction.decode((String)line);
        log.debug("Action: " + action);
        FileSystemAction.read((SCPCommand)cmd, (FileSystemAction)action, (FileSystem)fs);
    }

    private static void read(SCPCommand cmd, FileSystemAction action, FileSystem fs) throws IOException {
        if (action instanceof StartDirectory) {
            String directoryName = StartDirectory.access$000((StartDirectory)((StartDirectory)action));
            fs.startDirectory(directoryName);
            cmd.ack();
            while (true) {
                String nextLine = cmd.readLine();
                FileSystemAction nextAction = FileSystemAction.decode((String)nextLine);
                log.debug("Next action: " + nextAction);
                if (nextAction instanceof EndDirectory) break;
                FileSystemAction.read((SCPCommand)cmd, (FileSystemAction)nextAction, (FileSystem)fs);
            }
            fs.endDirectory(directoryName);
            cmd.ack();
        } else if (action instanceof File) {
            File file = (File)action;
            cmd.ack();
            fs.file(File.access$100((File)file), File.access$200((File)file), cmd.read(File.access$200((File)file)));
            log.debug("About to send ack for file");
            cmd.ack();
            cmd.readAck();
        }
    }

    private static FileSystemAction decode(String line) {
        if (line == null) {
            throw new NullPointerException();
        }
        if (line.length() == 0) {
            throw new IllegalArgumentException("Line has length zero");
        }
        char t = line.charAt(0);
        if (t == 'C' || t == 'D') {
            int length;
            int endLength = line.indexOf(32, 6);
            if (endLength == -1) {
                throw new IllegalArgumentException();
            }
            String s = line.substring(6, endLength);
            if (s.length() == 1 && s.charAt(0) == '0') {
                length = 0;
            } else {
                try {
                    length = Integer.parseInt(s);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Could not parse file length " + s);
                }
            }
            String name = line.substring(endLength + 1);
            if (t == 'D') {
                return new StartDirectory(name, null);
            }
            return new File(name, length, null);
        }
        if (t == 'E') {
            return new EndDirectory(null);
        }
        throw new IllegalArgumentException("Could not recognize file system action " + line);
    }
}

