/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.jarurl;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.crsh.vfs.spi.AbstractFSDriver;
import org.crsh.vfs.spi.jarurl.Handle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarURLDriver
extends AbstractFSDriver<Handle> {
    final Handle root;
    final URL jarURL;

    private static Handle get(JarURLDriver driver, Map<String, Handle> handles, String path) {
        Handle handle = handles.get(path);
        if (handle == null) {
            String name;
            Handle parent;
            handle = new Handle(driver, path);
            int to = path.length();
            if (path.charAt(to - 1) == '/') {
                --to;
            }
            int from = -1;
            for (int i = to - 1; i >= 0; --i) {
                if (path.charAt(i) != '/') continue;
                from = i;
                break;
            }
            if (from == -1) {
                parent = handles.get("");
                name = path.substring(0, to);
            } else {
                parent = JarURLDriver.get(driver, handles, path.substring(0, from));
                name = path.substring(from + 1, to);
            }
            parent.children.put(name, handle);
            handles.put(path.substring(0, to), handle);
        }
        return handle;
    }

    public JarURLDriver(JarURLConnection conn) throws IOException {
        JarFile file = conn.getJarFile();
        HashMap<String, Handle> handles = new HashMap<String, Handle>();
        this.root = new Handle(this, "");
        handles.put("", this.root);
        for (JarEntry entry : Collections.list(file.entries())) {
            Handle handle = JarURLDriver.get(this, handles, entry.getName());
            handle.entry = entry;
        }
        this.jarURL = conn.getJarFileURL();
    }

    @Override
    public Handle root() throws IOException {
        return this.root;
    }

    @Override
    public String name(Handle handle) throws IOException {
        return handle.path.getName();
    }

    @Override
    public boolean isDir(Handle handle) throws IOException {
        return handle.path.isDir();
    }

    @Override
    public Iterable<Handle> children(Handle handle) throws IOException {
        return handle.children.values();
    }

    @Override
    public URL toURL(Handle handle) throws IOException {
        return handle.toURL();
    }
}

