/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class SpreadMap
extends HashMap {
    private Map mapData;
    private int hashCode;

    public SpreadMap(Object[] values) {
        this.mapData = new HashMap(values.length / 2);
        int i = 0;
        while (i < values.length) {
            this.mapData.put(values[i++], values[i++]);
        }
    }

    public SpreadMap(Map map) {
        this.mapData = map;
    }

    public Object get(Object obj) {
        return this.mapData.get(obj);
    }

    public Object put(Object key, Object value) {
        throw new RuntimeException("SpreadMap: " + this + " is an immutable map, and so (" + key + ": " + value + ") cannot be added.");
    }

    public Object remove(Object key) {
        throw new RuntimeException("SpreadMap: " + this + " is an immutable map, and so the key (" + key + ") cannot be deleteded.");
    }

    public void putAll(Map t) {
        throw new RuntimeException("SpreadMap: " + this + " is an immutable map, and so the map (" + t + ") cannot be put in this spreadMap.");
    }

    public int size() {
        return this.mapData.keySet().size();
    }

    public boolean equals(Object that) {
        if (that instanceof SpreadMap) {
            return this.equals((SpreadMap)that);
        }
        return false;
    }

    public boolean equals(SpreadMap that) {
        if (that == null) {
            return false;
        }
        if (this.size() == that.size()) {
            SpreadMap other = that;
            for (Object key : this.mapData.keySet()) {
                if (DefaultTypeTransformation.compareEqual(this.get(key), other.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            for (Object key : this.mapData.keySet()) {
                int hash = key != null ? key.hashCode() : 47806;
                this.hashCode ^= hash;
            }
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.mapData.isEmpty()) {
            return "*:[:]";
        }
        StringBuffer buff = new StringBuffer("*:[");
        Iterator iter = this.mapData.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            buff.append(key + ":" + this.mapData.get(key));
            if (!iter.hasNext()) continue;
            buff.append(", ");
        }
        buff.append("]");
        return buff.toString();
    }
}

