/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.term.processor;

import java.io.IOException;
import org.crsh.shell.ShellProcess;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.term.TermEvent;
import org.crsh.term.processor.Processor;
import org.crsh.term.processor.Status;

class ProcessContext
implements ShellProcessContext,
Runnable {
    final Processor processor;
    final ShellProcess process;

    ProcessContext(Processor processor, ShellProcess process) {
        this.process = process;
        this.processor = processor;
    }

    public void run() {
        this.process.execute(this);
    }

    public int getWidth() {
        return this.processor.term.getWidth();
    }

    public String getProperty(String name) {
        return this.processor.term.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine(String msg, boolean echo) {
        try {
            this.processor.term.write(msg);
        }
        catch (IOException e) {
            return null;
        }
        boolean done = false;
        while (true) {
            Object object = this.processor.lock;
            synchronized (object) {
                switch (this.processor.status) {
                    case CLOSED: 
                    case CANCELLING: {
                        return null;
                    }
                    case PROCESSING: {
                        TermEvent event;
                        if (this.processor.queue.size() <= 0 || !((event = this.processor.queue.removeFirst()) instanceof TermEvent.ReadLine)) break;
                        return ((Object)((TermEvent.ReadLine)event).getLine()).toString();
                    }
                    default: {
                        throw new AssertionError((Object)("Does not make sense " + (Object)((Object)this.processor.status)));
                    }
                }
            }
            if (done) {
                return null;
            }
            done = true;
            this.processor.waitingEvent = true;
            try {
                this.processor.term.setEcho(echo);
                this.processor.readTerm();
                this.processor.term.write("\r\n");
                continue;
            }
            catch (IOException e) {
                this.processor.log.error("Error when readline line");
                continue;
            }
            finally {
                this.processor.waitingEvent = false;
                this.processor.term.setEcho(true);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(ShellResponse response) {
        Status status;
        ProcessContext context;
        Runnable runnable;
        Object object = this.processor.lock;
        synchronized (object) {
            this.processor.current = null;
            switch (this.processor.status) {
                case PROCESSING: {
                    if (response instanceof ShellResponse.Close) {
                        runnable = this.processor.CLOSE;
                        this.processor.status = Status.CLOSED;
                        break;
                    }
                    if (response instanceof ShellResponse.Cancelled) {
                        runnable = Processor.NOOP;
                        this.processor.status = Status.AVAILABLE;
                        break;
                    }
                    final String display = response.getText();
                    runnable = new Runnable(){

                        public void run() {
                            ProcessContext.this.processor.write(display);
                        }
                    };
                    this.processor.status = Status.AVAILABLE;
                    break;
                }
                case CANCELLING: {
                    runnable = Processor.NOOP;
                    this.processor.status = Status.AVAILABLE;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Does not make sense " + (Object)((Object)this.processor.status)));
                }
            }
            context = this.processor.peekProcess();
            status = this.processor.status;
        }
        runnable.run();
        if (context != null) {
            context.run();
        } else if (status == Status.AVAILABLE) {
            this.processor.writePrompt();
        }
    }
}

