/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.vfs.spi.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import org.crsh.vfs.spi.AbstractFSDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletContextDriver
extends AbstractFSDriver<String> {
    static final Pattern pathPattern = Pattern.compile("^(?=/).*?((?<=/)[^/]*)?(/?)$");
    private final ServletContext ctx;

    public ServletContextDriver(ServletContext ctx) {
        if (ctx == null) {
            throw new NullPointerException();
        }
        this.ctx = ctx;
    }

    @Override
    public String root() throws IOException {
        return "/";
    }

    @Override
    public String name(String file) throws IOException {
        return this.matcher(file).group(1);
    }

    @Override
    public boolean isDir(String file) throws IOException {
        Matcher matcher = this.matcher(file);
        String slash = matcher.group(2);
        return "/".equals(slash);
    }

    @Override
    public Iterable<String> children(String parent) throws IOException {
        return this.ctx.getResourcePaths(parent);
    }

    @Override
    public URL toURL(String file) throws IOException {
        File realFile;
        String realPath = this.ctx.getRealPath(file);
        if (realPath != null && (realFile = new File(realPath)).exists() && realFile.isFile()) {
            return realFile.toURI().toURL();
        }
        return this.ctx.getResource(file);
    }

    private Matcher matcher(String path) {
        Matcher m = pathPattern.matcher(path);
        if (m.matches()) {
            return m;
        }
        throw new IllegalArgumentException("Illegal path " + path);
    }
}

