/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetStringParser;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public abstract class ASN1OctetString
extends ASN1Object
implements ASN1OctetStringParser {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        DERObject dERObject = aSN1TaggedObject.getObject();
        if (bl || dERObject instanceof ASN1OctetString) {
            return ASN1OctetString.getInstance(dERObject);
        }
        return BERConstructedOctetString.fromSequence(ASN1Sequence.getInstance(dERObject));
    }

    public static ASN1OctetString getInstance(Object object) {
        if (object == null || object instanceof ASN1OctetString) {
            return (ASN1OctetString)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return ASN1OctetString.getInstance(((ASN1TaggedObject)object).getObject());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public ASN1OctetString(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("string cannot be null");
        }
        this.string = byArray;
    }

    public ASN1OctetString(DEREncodable dEREncodable) {
        try {
            this.string = dEREncodable.getDERObject().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Error processing object : " + iOException.toString());
        }
    }

    @Override
    public InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public ASN1OctetStringParser parser() {
        return this;
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    @Override
    boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString aSN1OctetString = (ASN1OctetString)dERObject;
        return Arrays.areEqual(this.string, aSN1OctetString.string);
    }

    @Override
    public DERObject getLoadedObject() {
        return this.getDERObject();
    }

    @Override
    abstract void encode(DEROutputStream var1) throws IOException;

    public String toString() {
        return "#" + new String(Hex.encode(this.string));
    }
}

