/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.impl.command;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.crsh.command.CommandInvoker;
import org.crsh.command.NoSuchCommandException;
import org.crsh.command.ScriptException;
import org.crsh.command.ShellCommand;
import org.crsh.shell.ErrorType;
import org.crsh.shell.ShellProcessContext;
import org.crsh.shell.ShellResponse;
import org.crsh.shell.impl.command.CRaSHProcess;
import org.crsh.shell.impl.command.CRaSHSession;
import org.crsh.shell.impl.command.InvocationContextImpl;
import org.crsh.text.CharReader;
import org.crsh.text.Style;

abstract class AST {
    AST() {
    }

    abstract Term lastTerm();

    static class Term
    extends AST {
        final String line;
        final Term next;
        final String name;
        final String rest;
        private ShellCommand command;
        private CommandInvoker invoker;

        Term(String line) {
            this(line, null);
        }

        Term(String line, Term next) {
            Pattern p = Pattern.compile("^\\s*(\\S+)");
            Matcher m = p.matcher(line);
            String name = null;
            String rest = null;
            if (m.find()) {
                name = m.group(1);
                rest = line.substring(m.end());
            }
            this.name = name;
            this.rest = rest;
            this.line = line;
            this.next = next;
        }

        private void create(CRaSHSession session) throws NoSuchCommandException {
            CommandInvoker<?, ?> invoker = null;
            if (this.name != null) {
                this.command = session.crash.getCommand(this.name);
                if (this.command != null) {
                    invoker = this.command.createInvoker(this.rest);
                }
            }
            if (invoker == null) {
                throw new NoSuchCommandException(this.name);
            }
            this.invoker = invoker;
            if (this.next != null) {
                this.next.create(session);
            }
        }

        String getLine() {
            return this.line;
        }

        Term lastTerm() {
            if (this.next != null) {
                return this.next.lastTerm();
            }
            return this;
        }

        private ShellResponse.Error build(Throwable throwable) {
            String result;
            ErrorType errorType;
            if (throwable instanceof ScriptException) {
                errorType = ErrorType.EVALUATION;
                Throwable cause = throwable.getCause();
                if (cause != null) {
                    throwable = cause;
                }
            } else {
                errorType = ErrorType.INTERNAL;
            }
            String msg = throwable.getMessage();
            if (throwable instanceof ScriptException) {
                result = msg == null ? this.name + ": failed" : this.name + ": " + msg;
                return ShellResponse.error(errorType, result, throwable);
            }
            if (msg == null) {
                msg = throwable.getClass().getSimpleName();
            }
            result = throwable instanceof RuntimeException ? this.name + ": exception: " + msg : (throwable instanceof Exception ? this.name + ": exception: " + msg : (throwable instanceof Error ? this.name + ": error: " + msg : this.name + ": unexpected throwable: " + msg));
            return ShellResponse.error(errorType, result, throwable);
        }
    }

    static class Expr
    extends AST {
        final Term term;
        final Expr next;

        Expr(Term term) {
            this.term = term;
            this.next = null;
        }

        Expr(Term term, Expr next) {
            this.term = term;
            this.next = next;
        }

        final CRaSHProcess create(CRaSHSession crash, String request) throws NoSuchCommandException {
            this.term.create(crash);
            if (this.next != null) {
                this.next.create(crash);
            }
            return new CRaSHProcess(crash, request){

                ShellResponse doInvoke(ShellProcessContext context) throws InterruptedException {
                    return Expr.this.execute(this.crash, context, null);
                }
            };
        }

        private void create(CRaSHSession crash) throws NoSuchCommandException {
            this.term.create(crash);
            if (this.next != null) {
                this.next.create(crash);
            }
        }

        protected ShellResponse execute(CRaSHSession crash, ShellProcessContext context, ArrayList consumed) throws InterruptedException {
            ArrayList produced = new ArrayList();
            CharReader reader = new CharReader();
            Term current = this.term;
            while (current != null) {
                InvocationContextImpl ctx = current.invoker.getConsumedType() == Void.class ? new InvocationContextImpl(context, null, crash.attributes, crash.crash.getContext().getAttributes()) : new InvocationContextImpl(context, consumed, crash.attributes, crash.crash.getContext().getAttributes());
                try {
                    current.invoker.invoke(ctx);
                }
                catch (ScriptException e) {
                    return current.build(e);
                }
                catch (Throwable t) {
                    return current.build(t);
                }
                CharReader ctxReader = ctx.getReader();
                if (ctxReader != null && !ctxReader.isEmpty()) {
                    reader.append((Object)ctxReader).append((Object)Style.reset);
                }
                if (current.invoker.getProducedType() != Void.class) {
                    produced.addAll(ctx.getProducedItems());
                }
                current = current.next;
            }
            if (this.next != null) {
                return this.next.execute(crash, context, produced);
            }
            ShellResponse.Ok response = !reader.isEmpty() ? ShellResponse.display(produced, reader) : ShellResponse.ok(produced);
            return response;
        }

        Term lastTerm() {
            if (this.next != null) {
                return this.next.lastTerm();
            }
            if (this.term != null) {
                return this.term.lastTerm();
            }
            return null;
        }
    }
}

