/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.Element;
import org.crsh.shell.ui.RowElement;
import org.crsh.shell.ui.UIWriterContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableElement
extends Element {
    public final int MARGIN = 5;
    private List<RowElement> rows = new ArrayList<RowElement>();
    private List<Integer> colsSize = new ArrayList<Integer>();

    public TableElement addRow(RowElement row) {
        this.rows.add(row);
        return this;
    }

    @Override
    void doPrint(UIWriterContext ctx, ShellWriter writer) throws IOException {
        ctx = new UIWriterContext(ctx);
        this.colsSize = this.computeColSize(ctx.getConsoleWidth());
        ctx.parentUIContext.pad(writer);
        for (RowElement e : this.rows) {
            e.print(ctx, writer);
        }
        ctx.pad(writer);
        writer.append("\n");
    }

    public List<RowElement> getRows() {
        return this.rows;
    }

    public List<Integer> getColsSize() {
        return Collections.unmodifiableList(this.colsSize);
    }

    private List<Integer> computeColSize(int consoleWidth) {
        ArrayList<Integer> colsSize = new ArrayList<Integer>();
        int colSum = 0;
        for (int i = 0; i < this.columnNumber(); ++i) {
            int colSize = 0;
            for (RowElement row : this.rows) {
                int missingSpace = colSum + (colSize = Math.max(colSize, row.getValues().get(i).width() + 5)) - consoleWidth;
                if (missingSpace <= 0) continue;
                colSize -= missingSpace;
            }
            colsSize.add(colSize);
            colSum += colSize;
        }
        return colsSize;
    }

    private int columnNumber() {
        int n = 0;
        for (RowElement row : this.rows) {
            n = Math.max(n, row.getValues().size());
        }
        return n;
    }

    @Override
    int width() {
        return 0;
    }
}

