/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.telnetd.io.toolkit;

import java.util.Vector;
import net.wimpi.telnetd.io.toolkit.BufferOverflowException;

class CharBuffer {
    private Vector m_Buffer;
    private int m_Size;

    public CharBuffer(int size) {
        this.m_Buffer = new Vector(size);
        this.m_Size = size;
    }

    public char getCharAt(int pos) throws IndexOutOfBoundsException {
        return ((Character)this.m_Buffer.elementAt(pos)).charValue();
    }

    public void setCharAt(int pos, char ch) throws IndexOutOfBoundsException {
        this.m_Buffer.setElementAt(new Character(ch), pos);
    }

    public void insertCharAt(int pos, char ch) throws BufferOverflowException, IndexOutOfBoundsException {
        this.m_Buffer.insertElementAt(new Character(ch), pos);
    }

    public void append(char aChar) throws BufferOverflowException {
        this.m_Buffer.addElement(new Character(aChar));
    }

    public void append(String str) throws BufferOverflowException {
        for (int i = 0; i < str.length(); ++i) {
            this.append(str.charAt(i));
        }
    }

    public void removeCharAt(int pos) throws IndexOutOfBoundsException {
        this.m_Buffer.removeElementAt(pos);
    }

    public void clear() {
        this.m_Buffer.removeAllElements();
    }

    public int size() {
        return this.m_Buffer.size();
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.m_Buffer.size(); ++i) {
            sbuf.append(((Character)this.m_Buffer.elementAt(i)).charValue());
        }
        return sbuf.toString();
    }

    public void ensureSpace(int chars) throws BufferOverflowException {
        if (chars > this.m_Size - this.m_Buffer.size()) {
            throw new BufferOverflowException();
        }
    }
}

