/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.shell.ui;

import java.io.IOException;
import org.crsh.command.InvocationContext;
import org.crsh.shell.io.ShellWriter;
import org.crsh.shell.ui.FormattingElement;
import org.crsh.shell.ui.UIWriterContext;
import org.crsh.text.Color;
import org.crsh.text.Decoration;
import org.crsh.text.Style;

public abstract class Element {
    private Decoration decoration;
    private Color foreground;
    private Color background;
    private Element parent;

    public void print(ShellWriter writer, InvocationContext context) throws IOException {
        this.print(new UIWriterContext(context), writer);
    }

    public void print(UIWriterContext ctx, ShellWriter writer) throws IOException {
        if (ctx == null) {
            throw new NullPointerException();
        }
        if (this.haveStyle()) {
            new FormattingElement(Style.style(this.getDecoration(), this.getForeground(), this.getBackground())).print(ctx, writer);
        }
        this.doPrint(ctx, writer);
        if (this.haveStyle()) {
            new FormattingElement(Style.reset).print(ctx, writer);
        }
    }

    abstract void doPrint(UIWriterContext var1, ShellWriter var2) throws IOException;

    abstract int width();

    private boolean haveStyle() {
        return this.getDecoration() != null || this.getForeground() != null || this.getBackground() != null;
    }

    public Decoration getDecoration() {
        if (this.decoration != null) {
            return this.decoration;
        }
        if (this.parent != null) {
            return this.parent.getDecoration();
        }
        return null;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent != null) {
            return this.parent.getForeground();
        }
        return null;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return null;
    }

    public void setDecoration(Decoration decoration) {
        this.decoration = decoration;
    }

    public void setForeground(Color foreground) {
        this.foreground = foreground;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public Element getParent() {
        return this.parent;
    }

    public void setParent(Element parent) {
        this.parent = parent;
    }
}

